<?php
/**
 * ps_bldr_contact.php
 *
 * This file contains contact
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<section class="contact-form" id="contactForm">

    <div class="google-maps"
        id="map-canvas"
        data-lat="<?php echo esc_attr(get_sub_field('ps_bldr_contact_map_lat' ));?>"
        data-lng="<?php echo esc_attr(get_sub_field('ps_bldr_contact_map_lng' ));?>"
        data-zoom="<?php echo esc_attr(get_sub_field('ps_bldr_contact_map_zoom' ));?>">
        <?php if( get_sub_field('ps_bldr_contact_markers') ):?>
            <?php foreach( get_sub_field('ps_bldr_contact_markers') as $marker ) : ?>
                <div class="marker" data-text="<?php echo esc_attr($marker['ps_bldr_contact_map_text']);?>" data-lat="<?php echo esc_attr($marker['ps_bldr_contact_map_lat']);?>" data-lng="<?php echo esc_attr($marker['ps_bldr_contact_map_lng']);?>"></div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="container">

        <div class="row contact-wrapper">

            <div class="col-md-4">

                <h1><span class="bold"><?php the_sub_field('ps_bldr_contact_title');?></span></h1>

                <p class="lead"><?php the_sub_field('ps_bldr_contact_txt');?></p>

                <div class="contacts-wrapper">

                    <?php if( pistacia_has_contacts() ) : ?>

                        <ul class="contacts">
                            <li><i class="fa fa-map-marker"></i><?php the_field('pistacia_contact_address','options');?></li>
                            <li><i class="fa fa-phone"></i><?php the_field('pistacia_contact_phone','options');?></li>
                            <li><i class="fa fa-envelope"></i><a href="mailto:<?php echo esc_html( antispambot( get_field( 'pistacia_contact_email','options' ) ) ); ?>"><?php echo esc_html( antispambot( get_field( 'pistacia_contact_email','options' ) ) ); ?></a></li>
                        </ul>

                    <?php endif; ?>

                </div>

                <?php if( pistacia_has_socials() ) : ?>
                    <div class="socialbar socialbar-inner socialbar-radius colorizesocial">
                        <?php pistacia_the_socials_list(); ?>
                    </div>
                <?php endif; ?>

            </div>

            <div class="col-md-8">

                <h1><span class="light"><?php esc_html_e('Contact','pistacia')?></span> <span class="extra-bold"><?php esc_html_e('us','pistacia');?></span></h1>

                <?php Pistacia_Ajax_Forms::the_contact_form(); ?>

            </div>

        </div>

    </div>

</section>