<?php

/**
 * acf_pro_posts_page.php
 *
 * ACF PRO plugin page builder advanced fields
 * Include posts and pages advanced fields gallery, video, secondary image etc
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

if ( function_exists( 'acf_add_local_field_group' ) ) {

    /**
     * Featured video
     */
    acf_add_local_field_group( array(
        'key'                   => 'group_ps_ftrdvd',
        'title'                 => esc_html__( 'Featured Video', 'pistacia' ),
        'fields'                => array(
            array(
                'key'               => 'field_ps_ftrdvd09182',
                'label'             => esc_html__( 'Add Video', 'pistacia' ),
                'name'              => 'pistacia_featured_video',
                'prefix'            => '',
                'type'              => 'oembed',
                'instructions'      => esc_html__( 'You can display the your video on blog front page like featured images. Just paste the video link. Allowed video links : http://codex.wordpress.org/Embeds', 'pistacia' ),
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'width'             => 800,
                'height'            => 600,
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_format',
                    'operator' => '==',
                    'value'    => 'video',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => array(),
    ) );


    /**
     * Set header settings
     */
    acf_add_local_field_group( array(
        'key'                   => 'group_ps_hdr',
        'title'                 => esc_html__( 'Secondary image', 'pistacia' ),
        'fields'                => array(
            array(
                'key'           => 'field_ps_hdr_3467232',
                'label'         => esc_html__( 'Secondary image', 'pistacia' ),
                'name'          => 'ps_header_img',
                'type'          => 'image',
                'instructions'  => esc_html__( 'Image for header section', 'pistacia' ),
                'return_format' => 'url',
                'preview_size'  => 'medium',
                'library'       => 'all',
            )
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'post',
                )
            ),
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'pistacia-recipes',
                )
            ),
            array(
                array(
                    'param'    => 'page_template',
                    'operator' => '==',
                    'value'    => 'default',
                )
            ),
            array(
                array(
                    'param'    => 'page_template',
                    'operator' => '==',
                    'value'    => 'page-gallery.php',
                )
            ),
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'gallery',
                )
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'side',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'field'
    ) );

}