<?php
/**
 * acf_pro_page_builder.php
 *
 * ACF PRO plugin page builder advanced fields
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

if ( function_exists( 'acf_add_local_field_group' ) ) {

    acf_add_local_field_group( array(
        'key'                   => 'group_bldr37462382344',
        'title'                 => 'Page Builder',
        'fields'                => array(
            array(
                'key'               => 'field_pagebuilder',
                'label'             => 'Build custom page',
                'name'              => 'ps_pg_builder',
                'prefix'            => '',
                'type'              => 'flexible_content',
                'instructions'      => esc_html__( 'You can create theme sections with this tool. Use "Add content block" button', 'pistacia' ),
                'required'          => 0,
                'conditional_logic' => 0,
                'button_label'      => esc_html__( 'Add content block', 'pistacia' ),
                'min'               => '',
                'max'               => '',
                'layouts'           => array(
                    array(
                        'key'        => 'layout_hdr6753437245',
                        'name'       => 'ps_bldr_header',
                        'label'      => esc_html__( 'Image header', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key'           => 'layout_hdr5543436743',
                                'label'         => esc_html__( 'Header image', 'pistacia' ),
                                'name'          => 'ps_bldr_hdr_img',
                                'type'          => 'image',
                                'return_format' => 'url',
                                'preview_size'  => 'medium',
                                'library'       => 'all',
                                'instructions'  => '',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => ''
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_wlcm3547567670',
                        'name'       => 'ps_bldr_welcomeheader',
                        'label'      => esc_html__( 'Welcome header', 'pistacia' ),
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_wlcm_01231232210',
                                'label' => esc_html__( 'Autplay', 'pistacia' ),
                                'name' => 'pistacia_wlcm_autoplay',
                                'type' => 'number',
                                'instructions' => esc_html__( 'Delay between transitions (in ms). If this parameter is not specified, auto play will be disabled', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> 0
                            ),
                            array(
                                'key'           => 'field_wlcm3547567671',
                                'label'         => esc_html__( 'Welcome slider items', 'pistacia' ),
                                'name'          => 'ps_bldr_wlcm_items',
                                'type'          => 'repeater',
                                'instructions'  => '',
                                'layout'        => 'row',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => '',
                                'min'  => 4,
                                'max'  => 4,
                                'button_label' => esc_html__( 'Add item', 'pistacia' ),
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_wlcm_21234500',
                                        'label' => esc_html__( 'Big image', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_limage',
                                        'type' => 'image',
                                        'return_format' => 'array',
                                        'preview_size' => 'medium',
                                        'instructions' => esc_html__( 'Upload big image of item', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234501',
                                        'label' => esc_html__( 'Small image', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_simage',
                                        'type' => 'image',
                                        'return_format' => 'array',
                                        'preview_size' => 'thumbnail',
                                        'instructions' => esc_html__( 'Upload small image of item', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234502',
                                        'label' => esc_html__( 'Icon text', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_icontxt',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type item icon title', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234506',
                                        'label' => esc_html__( 'Icon', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_icon',
                                        'type' => 'select',
                                        'instructions' => esc_html__( 'Select item icon', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> '',
                                        'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                        'allow_null'   => 0,
                                        'multiple'     => 0,
                                        'ui'           => 1,
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234503',
                                        'label' => esc_html__( 'Title', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_title',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type item title', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234504',
                                        'label' => esc_html__( 'Excerpt', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_excerpt',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type item description', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_21234505',
                                        'label' => esc_html__( 'Price', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_price',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type item price', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_wlcm_41322',
                                        'label' => esc_html__( 'Link', 'pistacia' ),
                                        'name' => 'pistacia_wlcm_item_link',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type link', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> ''
                                    ),
                                )
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_spclts3547567670',
                        'name'       => 'ps_bldr_specialties',
                        'label'      => esc_html__( 'Specialties form', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_spclts_21234500',
                                'label' => esc_html__( 'Large left image', 'pistacia' ),
                                'name' => 'pistacia_spclts_image',
                                'type' => 'image',
                                'return_format' => 'array',
                                'preview_size' => 'medium',
                                'instructions' => esc_html__( 'Upload image. Recommend wide 630px, height 950px', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_spclts_21234501',
                                'label' => esc_html__( 'Title light font', 'pistacia' ),
                                'name' => 'pistacia_spclts_titlelight',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type title light', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> 'Our chef'
                            ),
                            array(
                                'key' => 'field_spclts_21234502',
                                'label' => esc_html__( 'Title bold font', 'pistacia' ),
                                'name' => 'pistacia_spclts_titlebold',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type title bold', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> 'specialties'
                            ),
                            array(
                                'key' => 'field_spclts_21234503',
                                'label' => esc_html__( 'Excerpt', 'pistacia' ),
                                'name' => 'pistacia_spclts_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type description', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'           => 'field_spclts_41234504',
                                'label'         => esc_html__( 'Theree specialties items', 'pistacia' ),
                                'name'          => 'ps_bldr_spclts_items',
                                'type'          => 'repeater',
                                'instructions'  => '',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => '',
                                'min'  => 3,
                                'max'  => 3,
                                'button_label' => esc_html__( 'Add specialty', 'pistacia' ),
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_spclts_41234500',
                                        'label' => esc_html__( 'Photo', 'pistacia' ),
                                        'name' => 'pistacia_spclts_item_photo',
                                        'type' => 'image',
                                        'return_format' => 'array',
                                        'preview_size' => 'thumbnail',
                                        'instructions' => esc_html__( 'Upload image of specialty item', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_spclts_41234506',
                                        'label' => esc_html__( 'Icon', 'pistacia' ),
                                        'name' => 'pistacia_spclts_item_icon',
                                        'type' => 'select',
                                        'instructions' => esc_html__( 'Select specialty icon', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> '',
                                        'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                        'allow_null'   => 0,
                                        'multiple'     => 0,
                                        'ui'           => 1,
                                    ),
                                    array(
                                        'key' => 'field_spclts_41234503',
                                        'label' => esc_html__( 'Specialty name', 'pistacia' ),
                                        'name' => 'pistacia_spclts_item_title',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type name of specialty', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_spclts_41234505',
                                        'label' => esc_html__( 'Price', 'pistacia' ),
                                        'name' => 'pistacia_spclts_item_price',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type specialty price', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> ''
                                    ),
                                )
                            ),
                            array(
                                'key' => 'field_spclts_41234517',
                                'label' => esc_html__( 'Reservation hours', 'pistacia' ),
                                'name' => 'pistacia_spclts_hours',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type all hours separate "," chars. e.g: 12:00,12:30', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '12:30,13:00,13:30'
                            ),
                            array(
                                'key' => 'field_spclts_41234516',
                                'label' => esc_html__( 'Decor image', 'pistacia' ),
                                'name' => 'pistacia_spclts_dimage',
                                'type' => 'image',
                                'return_format' => 'array',
                                'preview_size' => 'thumbnail',
                                'instructions' => esc_html__( 'Upload decor image to section bottom. Recommend wide 170px, height 170px and transparent png', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_spclts_4223',
                                'label' => esc_html__( 'Turn off calendar', 'pistacia' ),
                                'name' => 'pistacia_spclts_calendar',
                                'type' => 'checkbox',
                                'required' => 0,
                                'default_value'=> 'off',
                                'instructions' => esc_html__( 'if checked then calendar turn off', 'pistacia' ),
                                'choices' => array(
                                    'off' => 'Off'
                                ),
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_rvltsl354756767112',
                        'name'       => 'ps_bldr_revolution',
                        'label'      => esc_html__( 'Revolution slider', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '1',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_rvltsl_1234567890',
                                'label' => esc_html__( 'Revolution slider', 'pistacia' ),
                                'name' => 'pistacia_rvltsl_alias',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type revolution slider alias', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_gmp3547567671',
                        'name'       => 'ps_bldr_gmap',
                        'label'      => esc_html__( 'Google map', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_gmp_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'pistacia_gmp_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_gmp_1234567899',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'pistacia_gmp_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_gmp_12345678994',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_gmp_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_gmp_1234567891',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'pistacia_gmp_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),

                            array(
                                'key'      => 'field_gmp_1234567892',
                                'label'    => esc_html__( 'Map latitude', 'pistacia' ),
                                'name'     => 'ps_gmp_map_lat',
                                'type'     => 'number',
                                'required' => 1
                            ),
                            array(
                                'key'      => 'field_gmp_1234567893',
                                'label'    => esc_html__( 'Map longtitude', 'pistacia' ),
                                'name'     => 'ps_gmp_map_lng',
                                'type'     => 'number',
                                'required' => 1
                            ),
                            array(
                                'key'      => 'field_gmp_1234567895',
                                'label'    => esc_html__( 'Map zoom param', 'pistacia' ),
                                'name'     => 'ps_gmp_map_zoom',
                                'type'     => 'number',
                                'required' => 1,
                                'min'=> 1,
                                'max'=> 20,
                                'step' => 1
                            ),
                            array(
                                'key' => 'field_gmp_1234567894',
                                'label' => esc_html__( 'Maps markers', 'pistacia' ),
                                'name' => 'pistacia_gmp_markers',
                                'type' => 'repeater',
                                'instructions' => esc_html__( 'Add Google maps markers', 'pistacia' ),
                                'required' => 0,
                                'min'          => 1,
                                'max'          => 0,
                                'button_label' => esc_html__( 'Add marker', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key'      => 'field_gmpm_1234567890',
                                        'label'    => esc_html__( 'Marker latitude', 'pistacia' ),
                                        'name'     => 'ps_gmpm_map_lat',
                                        'type'     => 'number',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_gmpm_1234567891',
                                        'label'    => esc_html__( 'Marker longtitude', 'pistacia' ),
                                        'name'     => 'ps_gmpm_map_lng',
                                        'type'     => 'number',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_gmpm_1234567892',
                                        'label'    => esc_html__( 'Marker text', 'pistacia' ),
                                        'name'     => 'ps_gmpm_map_text',
                                        'type'     => 'wysiwyg',
                                        'tabs'     => 'all',
                                        'toolbar'  => 'full',
                                        'required' => 1
                                    ),
                                )
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_ltstpsts3547567671',
                        'name'       => 'ps_bldr_latestposts',
                        'label'      => esc_html__( 'Masonry posts', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_ltstpsts_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_ltstpsts_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_ltstpsts_1234567899',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_ltstpsts_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_ltstpsts_12345678994',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_ltstpsts_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_ltstpsts_1234567891',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'ps_ltstpsts_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_qtcrsl3547567671',
                        'name'       => 'ps_bldr_quotecarousel',
                        'label'      => esc_html__( 'Testimonal carousel', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_qtcrsl_41234516',
                                'label' => esc_html__( 'Background image', 'pistacia' ),
                                'name' => 'pistacia_qtcrsl_image',
                                'type' => 'image',
                                'return_format' => 'url',
                                'preview_size' => 'medium',
                                'instructions' => esc_html__( 'Upload section background image', 'pistacia' ),
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_qtcrsl_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_qtcrsl_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_qtcrsl_1234567899',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_qtcrsl_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_qtcrsl_1234567892',
                                'label' => esc_html__( 'Quotes', 'pistacia' ),
                                'name' => 'pistacia_qtcrsl_items',
                                'type' => 'repeater',
                                'instructions' => esc_html__( 'Add quotes', 'pistacia' ),
                                'required' => 0,
                                'min'          => 1,
                                'max'          => '',
                                'layout'       => 'columns',
                                'button_label' => esc_html__( 'Add quotes', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key' => 'field_qtcrsl_1234567891233',
                                        'label' => esc_html__( 'Quote text', 'pistacia' ),
                                        'name' => 'ps_qtcrsl_q_text',
                                        'type' => 'textarea',
                                        'instructions' => esc_html__( 'Type quote text', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_qtcrsl_123456789122',
                                        'label' => esc_html__( 'Who said?', 'pistacia' ),
                                        'name' => 'ps_qtcrsl_q_name',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type person name', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                )
                            ),

                        ),

                    ),
                    array(
                        'key'        => 'layout_cntrp3547567671',
                        'name'       => 'ps_bldr_counterup',
                        'label'      => esc_html__( 'Counter up block', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '1',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_cntrp_41234516',
                                'label' => esc_html__( 'Background image', 'pistacia' ),
                                'name' => 'pistacia_cntrp_image',
                                'type' => 'image',
                                'return_format' => 'url',
                                'preview_size' => 'thumbnail',
                                'instructions' => esc_html__( 'Upload section background image', 'pistacia' ),
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_cntrp_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'pistacia_cntrp_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_cntrp_1234567891',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'pistacia_cntrp_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_cntrp_1234567892',
                                'label' => esc_html__( 'Counters items', 'pistacia' ),
                                'name' => 'pistacia_cntrp_counters',
                                'type' => 'repeater',
                                'instructions' => esc_html__( 'Add counter items', 'pistacia' ),
                                'required' => 0,
                                'min'          => 4,
                                'max'          => 4,
                                'layout'       => 'columns',
                                'button_label' => esc_html__( 'Add counter item', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key'      => 'field_cntrp_12345678932',
                                        'label'    => esc_html__( 'Counter title', 'pistacia' ),
                                        'name'     => 'ps_cntrpc_title',
                                        'type'     => 'text',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_cntrp_12345678942',
                                        'label'    => esc_html__( 'Counter number', 'pistacia' ),
                                        'name'     => 'ps_cntrpc_number',
                                        'type'     => 'number',
                                        'required' => 1
                                    ),
                                )
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_srvccrsl671',
                        'name'       => 'ps_bldr_service_carousel',
                        'label'      => esc_html__( 'Service carousel block', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_srvccrs_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_srvccrs_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_srvccrs_1234567891',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_srvccrs_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_srvccrs_123456789122',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_srvccrs_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_srvccrs_1234567892',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'ps_srvccrs_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_srvccrs_1234567893',
                                'label' => esc_html__( 'Carousel items', 'pistacia' ),
                                'name' => 'ps_srvccrs_carousels',
                                'type' => 'repeater',
                                'instructions' => esc_html__( 'Add carousel items', 'pistacia' ),
                                'required' => 0,
                                'min'          => 1,
                                'max'          => '',
                                'layout'       => 'columns',
                                'button_label' => esc_html__( 'Add item', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key'      => 'field_cntrpc_1234567897',
                                        'label'    => esc_html__( 'Carousel icon', 'pistacia' ),
                                        'name'     => 'ps_srvccrsc_icon',
                                        'type' => 'select',
                                        'instructions' => esc_html__( 'Select item icon', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> '',
                                        'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                        'allow_null'   => 0,
                                        'multiple'     => 0,
                                        'ui'           => 1,
                                    ),
                                    array(
                                        'key'      => 'field_cntrp_1234567894',
                                        'label'    => esc_html__( 'Carousel title', 'pistacia' ),
                                        'name'     => 'ps_srvccrsc_title',
                                        'type'     => 'text',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_cntrpc_1234567895',
                                        'label'    => esc_html__( 'Carousel excerpt', 'pistacia' ),
                                        'name'     => 'ps_srvccrsc_excerpt',
                                        'type'     => 'textarea',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_cntrpc_1234567896',
                                        'label'    => esc_html__( 'Carousel link', 'pistacia' ),
                                        'name'     => 'ps_srvccrsc_link',
                                        'type'     => 'text',
                                        'required' => 0
                                    ),
                                )
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_srvcblck1234',
                        'name'       => 'ps_bldr_services_blocks',
                        'label'      => esc_html__( 'Services blocks', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_srvcblck_123456789023',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_srvcblck_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_srvcblck_1234567891234',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_srvcblck_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_srvcblck_123456789122234',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_srvcblck_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_srvcblck_1234567892345',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'ps_srvcblck_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_srvcblck_1234567890',
                                'label' => esc_html__( 'Carousel items', 'pistacia' ),
                                'name' => 'ps_srvcblck_items',
                                'type' => 'repeater',
                                'instructions' => esc_html__( 'Add services items', 'pistacia' ),
                                'required' => 0,
                                'min'          => 1,
                                'max'          => '',
                                'button_label' => esc_html__( 'Add item', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key'      => 'field_srvcblck_1234567897',
                                        'label'    => esc_html__( 'Service icon', 'pistacia' ),
                                        'name'     => 'ps_srvcblck_icon',
                                        'type' => 'select',
                                        'instructions' => esc_html__( 'Select item icon', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> '',
                                        'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                        'allow_null'   => 0,
                                        'multiple'     => 0,
                                        'ui'           => 1,
                                    ),
                                    array(
                                        'key'      => 'field_srvcblck_1234567894',
                                        'label'    => esc_html__( 'Service title', 'pistacia' ),
                                        'name'     => 'ps_srvcblck_title',
                                        'type'     => 'text',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_srvcblck_1234567895',
                                        'label'    => esc_html__( 'Service excerpt', 'pistacia' ),
                                        'name'     => 'ps_srvcblck_excerpt',
                                        'type'     => 'textarea',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_srvcblck_1234567896',
                                        'label'    => esc_html__( 'Service link', 'pistacia' ),
                                        'name'     => 'ps_srvcblck_link',
                                        'type'     => 'text',
                                        'required' => 0
                                    ),
                                )
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_glrs3213456434',
                        'name'       => 'ps_bldr_galleries',
                        'label'      => esc_html__( 'Galleries block', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '1',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_glrs_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_glrs_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_glrs_1234567891',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_glrs_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_glrs_123456789122',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_glrs_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_glrs_1234567892',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'ps_glrs_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_glrs_12345678988',
                                'label' => esc_html__( 'Galleries number', 'pistacia' ),
                                'name' => 'ps_glrs_number',
                                'instructions' => esc_html__( 'How many latest galleries display?', 'pistacia' ),
                                'required' => 0,
                                'type' => 'radio',
                                'default_value' => '0',
                                'choices' => array(
                                    '4' => esc_html__( '4 galleries', 'pistacia' ),
                                    '8' => esc_html__( '8 galleries', 'pistacia' ),
                                    '12' => esc_html__( '12 galleries', 'pistacia' ),
                                    '-1' => esc_html__( 'All galleries', 'pistacia' ),
                                ),
                            ),
                        ),

                    ),
                    array(
                        'key'        => 'layout_lgsldr5346567567',
                        'name'       => 'ps_bldr_logoslider',
                        'label'      => esc_html__( 'Logo slider', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key'           => 'field_lgsldr32355533678',
                                'label'         => esc_html__( 'Full width slider', 'pistacia' ),
                                'name'          => 'ps_lg_sldr_fullwidth',
                                'instructions'  => 'Display slider full width or not.',
                                'required'      => 1,
                                'type' => 'radio',
                                'default_value' => '1',
                                'choices' => array(
                                    '1' => esc_html__( 'Full width', 'pistacia' ),
                                    '0' => esc_html__( 'No full width', 'pistacia' ),
                                ),
                            ),
                            array(
                                'key'           => 'field_lgsldr32355336',
                                'label'         => esc_html__( 'Logo slider items', 'pistacia' ),
                                'name'          => 'ps_lg_sldr_items',
                                'type'          => 'gallery',
                                'return_format' => 'object',
                                'instructions'  => '',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => ''
                            )
                        )
                    ),
                    array(
                        'key'        => 'layout_lgsldrl5346567567',
                        'name'       => 'ps_bldr_logoslider_link',
                        'label'      => esc_html__( 'Logo slider width link', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key'           => 'field_lgsldrl32355533678',
                                'label'         => esc_html__( 'Full width slider', 'pistacia' ),
                                'name'          => 'ps_lg_sldrl_fullwidth',
                                'instructions'  => 'Display slider full width or not.',
                                'required'      => 1,
                                'type' => 'radio',
                                'default_value' => '1',
                                'choices' => array(
                                    '1' => esc_html__( 'Full width', 'pistacia' ),
                                    '0' => esc_html__( 'No full width', 'pistacia' ),
                                ),
                            ),
                            array(
                                'key'           => 'field_lgsldrl32355336',
                                'label'         => esc_html__( 'Logo slider items', 'pistacia' ),
                                'name'          => 'ps_lg_sldrl_items',
                                'type'          => 'repeater',
                                'instructions'  => '',
                                'required'      => 1,
                                'default_value' => '',
                                'placeholder'   => '',
                                'layout'=>'column',
                                'min'  => 1,
                                'max'  => '',
                                'button_label' => esc_html__( 'Add logo', 'pistacia' ),
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_sldrl_41234500',
                                        'label' => esc_html__( 'Photo', 'pistacia' ),
                                        'name' => 'pistacia_sldrl_item_photo',
                                        'type' => 'image',
                                        'return_format' => 'array',
                                        'preview_size' => 'thumbnail',
                                        'instructions' => esc_html__( 'Upload logo', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_sldrl_41234503',
                                        'label' => esc_html__( 'Logo link', 'pistacia' ),
                                        'name' => 'pistacia_sldrl_item_link',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type link. If you want internal link please use "/about-us" format', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                )
                            ),
                        )
                    ),
                    array(
                        'key'        => 'layout_mncrds5346567567',
                        'name'       => 'ps_bldr_menucards',
                        'label'      => esc_html__( 'Menu cards', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_mncrds_1234567890',
                                'label' => esc_html__( 'Section title light', 'pistacia' ),
                                'name' => 'ps_mncrds_title_l',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title light text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_mncrds_1234567891',
                                'label' => esc_html__( 'Section title bold', 'pistacia' ),
                                'name' => 'ps_mncrds_title_b',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type section title bold text', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'      => 'field_mncrds_123456789122',
                                'label'    => esc_html__( 'Title icon', 'pistacia' ),
                                'name'     => 'ps_mncrds_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select title icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_mncrds_1234567892',
                                'label' => esc_html__( 'Section excerpt', 'pistacia' ),
                                'name' => 'ps_mncrds_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type section excerpt', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key'           => 'field_mncrds_41234504',
                                'label'         => esc_html__( 'Cards', 'pistacia' ),
                                'name'          => 'ps_bldr_mncrds_items',
                                'type'          => 'repeater',
                                'instructions'  => '',
                                'required'      => 1,
                                'default_value' => '',
                                'placeholder'   => '',
                                'layout'=>'row',
                                'min'  => 1,
                                'max'  => '',
                                'button_label' => esc_html__( 'Add card', 'pistacia' ),
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_mncrds_41234500',
                                        'label' => esc_html__( 'Photo', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_photo',
                                        'type' => 'image',
                                        'return_format' => 'array',
                                        'preview_size' => 'thumbnail',
                                        'instructions' => esc_html__( 'Upload image of card', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_mncrds_41234503',
                                        'label' => esc_html__( 'Card title', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_title',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type card name', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_mncrds_4123450323',
                                        'label' => esc_html__( 'Card excerpt', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_excerpt',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type card excerpt', 'pistacia' ),
                                        'required' => 1,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_mncrds_41234505',
                                        'label' => esc_html__( 'Price', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_price',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type item price', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> ''
                                    ),
                                    array(
                                        'key' => 'field_mncrds_412345052344',
                                        'label' => esc_html__( 'Stars', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_stars',
                                        'type' => 'number',
                                        'min'=> '1',
                                        'max'=> '5',
                                        'instructions' => esc_html__( 'Type card stars', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> '1'
                                    ),
                                    array(
                                        'key' => 'field_mncrds_412345032311',
                                        'label' => esc_html__( 'Card link', 'pistacia' ),
                                        'name' => 'pistacia_mncrds_item_link',
                                        'type' => 'text',
                                        'instructions' => esc_html__( 'Type card link', 'pistacia' ),
                                        'required' => 0,
                                        'default_value'=> ''
                                    ),
                                )
                            ),
                        )
                    ),
                    array(
                        'key'        => 'layout_rcpssldr012345678',
                        'name'       => 'ps_bldr_recipes_slider',
                        'label'      => esc_html__( 'Recipes slider section', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key'           => 'field_rcpssldr01211',
                                'label'         => esc_html__( 'Section background image', 'pistacia' ),
                                'name'          => 'ps_rcpssldr_section_bg',
                                'instructions'  => 'Section background',
                                'required'      => 0,
                                'type' => 'image',
                                'return_format' => 'url',
                                'preview_size' => 'thumbnail',
                            ),
                            array(
                                'key'           => 'field_rcpssldr0123',
                                'label'         => esc_html__( 'Recipes number show', 'pistacia' ),
                                'name'          => 'ps_rcpssldr_perpage',
                                'instructions'  => 'How many recipes show',
                                'required'      => 1,
                                'type' => 'number',
                                'default_value' => '10',
                            ),
                            array(
                                'key'           => 'field_rcpssldr0124',
                                'label'         => esc_html__( 'Slider type', 'pistacia' ),
                                'name'          => 'ps_rcpssldr_type',
                                'instructions'  => 'Recipes slider type',
                                'required'      => 1,
                                'choices'      => array(
                                    'header' => 'Header',
                                ),
                                'type' => 'select',
                                'default_value' => 'header',
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key'           => 'field_rcpssldr0125',
                                'label'         => esc_html__( 'Order by', 'pistacia' ),
                                'name'          => 'ps_rcpssldr_orderby',
                                'instructions'  => 'Recipes list order by',
                                'required'      => 1,
                                'choices'      => array(
                                    'date' => 'Datetime',
                                    'title' => 'Title',
                                    'comment_count' => 'Comment count',
                                    'modified' => 'Modified'

                                ),
                                'type' => 'select',
                                'default_value' => 'date',
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key'           => 'field_rcpssldr0126',
                                'label'         => esc_html__( 'Sorting', 'pistacia' ),
                                'name'          => 'ps_rcpssldr_sorting',
                                'instructions'  => 'Recipes sorting ASC or DESC',
                                'required'      => 1,
                                'choices'      => array(
                                    'ASC' => 'Ascendent',
                                    'DESC' => 'Descendent'
                                ),
                                'type' => 'select',
                                'default_value' => 'date',
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                        )
                    ),
                    array(
                        'key'        => 'layout_rcpstps012345678',
                        'name'       => 'ps_bldr_recipes_tops',
                        'label'      => esc_html__( 'Recipes tops section', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => '',
                        'sub_fields' => array(
                            array(
                                'key'           => 'field_rcpstps0123',
                                'label'         => esc_html__( 'Recipes show', 'pistacia' ),
                                'name'          => 'ps_rcpstps_perpage',
                                'instructions'  => 'How many recipes show',
                                'required'      => 1,
                                'type' => 'number',
                                'default_value' => '5',
                            ),
                            array(
                                'key'           => 'field_rcpstps0124',
                                'label'         => esc_html__( 'Section style', 'pistacia' ),
                                'name'          => 'ps_rcpstps_style',
                                'instructions'  => 'Recipes section style',
                                'required'      => 1,
                                'choices'      => array(
                                    'dark' => 'Dark',
                                    'light' => 'Light'
                                ),
                                'type' => 'select',
                                'default_value' => 'light',
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                        )
                    ),
                    array(
                        'key'        => 'layout_vdblck6753437245',
                        'name'       => 'ps_bldr_video_block',
                        'label'      => esc_html__( 'Block with embed video', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 0,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_vdblck_2123134504',
                                'label' => esc_html__( 'Layout', 'pistacia' ),
                                'name' => 'pistacia_vdblck_layout',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select layout', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => array(
                                    'ps_text_top' => 'Video with text top',
                                    'ps_text_left' => 'Video with text left',
                                    'ps_text_right' => 'Video with text right',
                                ),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key'           => 'layout_vdblck0000001',
                                'label'         => esc_html__( 'Embed video', 'pistacia' ),
                                'name'          => 'ps_bldr_vdblck_video',
                                'type'          => 'oembed',
                                'instructions'  => esc_html__( 'Just paste the video link. Allowed video links : http://codex.wordpress.org/Embeds', 'pistacia' ),
                                'required'      => 1,
                                'default_value' => '',
                                'placeholder'   => ''
                            ),
                            array(
                                'key' => 'field_vdblck_21234506',
                                'label' => esc_html__( 'Icon', 'pistacia' ),
                                'name' => 'pistacia_vdblck_icon',
                                'type' => 'select',
                                'instructions' => esc_html__( 'Select icon', 'pistacia' ),
                                'required' => 1,
                                'default_value'=> '',
                                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                                'allow_null'   => 0,
                                'multiple'     => 0,
                                'ui'           => 1,
                            ),
                            array(
                                'key' => 'field_vdblck_21234501',
                                'label' => esc_html__( 'Title light font', 'pistacia' ),
                                'name' => 'pistacia_vdblck_titlelight',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type title light', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_vdblck_21234502',
                                'label' => esc_html__( 'Title bold font', 'pistacia' ),
                                'name' => 'pistacia_vdblck_titlebold',
                                'type' => 'text',
                                'instructions' => esc_html__( 'Type title bold', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            ),
                            array(
                                'key' => 'field_vdblck_21234503',
                                'label' => esc_html__( 'Excerpt', 'pistacia' ),
                                'name' => 'pistacia_vdblck_excerpt',
                                'type' => 'textarea',
                                'instructions' => esc_html__( 'Type description', 'pistacia' ),
                                'required' => 0,
                                'default_value'=> ''
                            )
                        ),

                    ),
                    array(
                        'key'        => 'layout_bldr0918273',
                        'name'       => 'ps_bldr_contact',
                        'label'      => esc_html__( 'Contact with map', 'pistacia' ),
                        'display'    => 'row',
                        'min'        => '',
                        'max'        => 1,
                        'sub_fields' => array(
                            array(
                                'key'           => 'field_bldr1242578544',
                                'label'         => esc_html__( 'Contact box title', 'pistacia' ),
                                'name'          => 'ps_bldr_contact_title',
                                'type'          => 'text',
                                'instructions'  => '',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => ''
                            ),
                            array(
                                'key'           => 'field_bldr746352342',
                                'label'         => esc_html__( 'Contact box text', 'pistacia' ),
                                'name'          => 'ps_bldr_contact_txt',
                                'type'          => 'text',
                                'instructions'  => '',
                                'required'      => 0,
                                'default_value' => '',
                                'placeholder'   => '',
                                'maxlength'     => 70,
                            ),
                            array(
                                'key'           => 'field_bldr9684732',
                                'label'         => esc_html__( 'Map latitude param', 'pistacia' ),
                                'instructions'  => '',
                                'name'          => 'ps_bldr_contact_map_lat',
                                'type'          => 'number',
                                'required'      => 1,
                                'default_value' => '36.276663'
                            ),
                            array(
                                'key'           => 'field_bldr874639462',
                                'label'         => esc_html__( 'Map longitude param', 'pistacia' ),
                                'instructions'  => '',
                                'name'          => 'ps_bldr_contact_map_lng',
                                'type'          => 'number',
                                'required'      => 1,
                                'default_value' => '-114.932512'
                            ),
                            array(
                                'key'           => 'field_bldr56735648',
                                'label'         => esc_html__( 'Map zoom param', 'pistacia' ),
                                'instructions'  => '',
                                'name'          => 'ps_bldr_contact_map_zoom',
                                'type'          => 'number',
                                'required'      => 1,
                                'max'           => '16',
                                'min'           => '5',
                                'default_value' => '14'
                            ),
                            array(
                                'key'          => 'field_bldr333454387',
                                'label'        => esc_html__( 'Map markers', 'pistacia' ),
                                'instructions' => esc_html__( 'Use "Add marker" button to create marker', 'pistacia' ),
                                'name'         => 'ps_bldr_contact_markers',
                                'type'         => 'repeater',
                                'required'     => 0,
                                'max'          => 0,
                                'layout'       => 'row',
                                'button_label' => esc_html__( 'Add marker', 'pistacia' ),
                                'sub_fields'   => array(
                                    array(
                                        'key'      => 'field_qAsxYcfRtzo34u4',
                                        'label'    => esc_html__( 'Marker lat', 'pistacia' ),
                                        'name'     => 'ps_bldr_contact_map_lat',
                                        'type'     => 'number',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_bldr46623523',
                                        'label'    => esc_html__( 'Marker lng', 'pistacia' ),
                                        'name'     => 'ps_bldr_contact_map_lng',
                                        'type'     => 'number',
                                        'required' => 1
                                    ),
                                    array(
                                        'key'      => 'field_bldr5733958',
                                        'label'    => esc_html__( 'Marker text', 'pistacia' ),
                                        'name'     => 'ps_bldr_contact_map_text',
                                        'type'     => 'wysiwyg',
                                        'tabs'     => 'all',
                                        'toolbar'  => 'full',
                                        'required' => 1
                                    ),
                                )
                            ),
                        ),

                    ),
                )
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'page_template',
                    'operator' => '==',
                    'value'    => 'page-builder.php',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => array(
            0 => 'the_content',
            1 => 'comments',
            2 => 'featured_image',
            3 => 'discussion',
            4 => 'slug',
            5 => 'revisions',
            6 => 'author',
            7 => 'custom_fields'
        )
    ) );
}