<?php
/**
 * acf_pro_options.php
 *
 * ACF PRO plugin theme setup
 * Theme options advanced fields
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

if ( function_exists( 'acf_add_local_field_group' ) ){

    /**
     * Theme option tabs
     */

    $google_fonts = Pistacia_Google_Fonts::get_instance();

    $args = array(
        'key' => 'group_pistacia_ptns1',
        'title' => esc_html__( 'Theme options', 'pistacia' ),
        'fields' => array(
            array(
                'key' => 'field_pistacia_thms0',
                'label' => esc_html__( 'General setup', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key' => 'field_pistacia_thms5',
                'label' => esc_html__( 'Page background color', 'pistacia' ),
                'name' => 'pistacia_o_bg_color',
                'instructions' => esc_html__( 'Background color', 'pistacia' ),
                'type' => 'color_picker',
                'default_value' => '#fff'
            ),
            array(
                'key' => 'field_pistacia_thms6',
                'label' => esc_html__( 'Page primary color', 'pistacia' ),
                'name' => 'pistacia_o_primary_color',
                'instructions' => esc_html__( 'Theme primary color', 'pistacia' ),
                'type' => 'color_picker',
                'default_value' => '#8dc63f'
            ),
            array(
                'key' => 'field_pistacia_thms7',
                'label' => esc_html__( 'Page primary darken color', 'pistacia' ),
                'name' => 'pistacia_o_primary_darken_color',
                'instructions' => esc_html__( 'Theme primary darken color use button hover etc', 'pistacia' ),
                'type' => 'color_picker',
                'default_value' => '#72a230'
            ),
            array(
                'key' => 'field_pistacia_thms1',
                'label' => esc_html__( 'Boxed layout', 'pistacia' ),
                'name' => 'pistacia_o_theme_setup_boxed',
                'instructions' => esc_html__( 'Layout boxed or wide', 'pistacia' ),
                'type' => 'radio',
                'default_value' => 'wide',
                'choices' => array(
                    'boxed' => esc_html__( 'Boxed', 'pistacia' ),
                    'wide' => esc_html__( 'Wide', 'pistacia' ),
                ),
            ),
            array(
                'key' => 'field_pistacia_thms2',
                'label' => esc_html__( 'Fixed navigation', 'pistacia' ),
                'name' => 'pistacia_o_theme_setup_fixednavigation',
                'instructions' => esc_html__( 'Navigation fixed or not fixed', 'pistacia' ),
                'type' => 'radio',
                'default_value' => '0',
                'choices' => array(
                    'off' => esc_html__( 'Off', 'pistacia' ),
                    'on' => esc_html__( 'On', 'pistacia' ),
                ),
            ),
            array(
                'key' => 'field_pistacia_thms3',
                'label' => esc_html__( 'Navigation alignment', 'pistacia' ),
                'name' => 'pistacia_o_theme_setup_navalign',
                'instructions' => esc_html__( 'Navigation align left or right', 'pistacia' ),
                'type' => 'radio',
                'default_value' => 'left',
                'choices' => array(
                    'left' => esc_html__( 'Left', 'pistacia' ),
                    'right' => esc_html__( 'Right', 'pistacia' ),
                ),
            ),
            array(
                'key' => 'field_pistacia_gmp0',
                'label' => esc_html__( 'Google map', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key'      => 'field_pistacia_gmp1',
                'label'    => esc_html__( 'Google Maps API key', 'pistacia' ),
                'name'     => 'pistacia_contact_map_api_key',
                'type'     => 'text',
                'instructions' => esc_html__('Please write Google API key','pistacia') . ' <a href="https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key">'.esc_html__('Documentation and get API key','pistacia').'</a>',
                'required' => 0
            ),
            array(
                'key' => 'field_pistacia_gfnt0',
                'label' => esc_html__( 'Fonts setup', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key'           => 'field_pistacia_gfnt1',
                'label'         => esc_html__( 'Theme primary font', 'pistacia' ),
                'name'          => 'pistacia_o_primary_font',
                'instructions'  => 'Primary font ( body, content, paragraph etc )',
                'required'      => 0,
                'choices'      => array_merge( array('default' => 'Default'), $google_fonts->get_google_fonts_choices( 'primary' ) ) ,
                'default_value' => 'merriweather',
                'type' => 'select',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_gfnt2',
                'label'         => esc_html__( 'Theme secondary font', 'pistacia' ),
                'name'          => 'pistacia_o_secondary_font',
                'instructions'  => 'Secondary font ( title )',
                'required'      => 0,
                'choices'      => array_merge( array('default' => 'Default'), $google_fonts->get_google_fonts_choices( 'secondary' ) ),
                'type' => 'select',
                'default_value' => 'raleway',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_gfnt3',
                'label'         => esc_html__( 'Theme body font color', 'pistacia' ),
                'name'          => 'pistacia_o_body_font_color',
                'instructions'  => '',
                'required'      => 0,
                'type' => 'color_picker',
                'default_value' => '#fff'
            ),
            array(
                'key' => 'field_pistacia_blg0',
                'label' => esc_html__( 'Blog', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key'           => 'field_pistacia_blg1',
                'label'         => esc_html__( 'Products per page', 'pistacia' ),
                'name'          => 'pistacia_o_blog_perpage',
                'instructions'  => 'Posts per page',
                'required'      => 0,
                'type' => 'number',
                'min' => 1,
                'default_value' => 3,
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_blg2',
                'label'         => esc_html__( 'Blog post page aside layout', 'pistacia' ),
                'name'          => 'pistacia_o_blog_aside',
                'instructions'  => 'Blog products page aside layout left or right',
                'required'      => 0,
                'choices'      => array(
                    'left' => esc_html__('Left align','pistacia'),
                    'right' => esc_html__('Right align','pistacia'),
                ),
                'type' => 'select',
                'default_value' => 'left',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_blg3',
                'label'         => esc_html__( 'Blog single page aside layout', 'pistacia' ),
                'name'          => 'pistacia_o_blogs_aside',
                'instructions'  => 'Blog single page aside layout left or right',
                'required'      => 0,
                'choices'      => array(
                    'left' => esc_html__('Left align','pistacia'),
                    'right' => esc_html__('Right align','pistacia'),
                ),
                'type' => 'select',
                'default_value' => 'left',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key' => 'field_pistacia_shp0',
                'label' => esc_html__( 'Shop', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key'           => 'field_pistacia_shp1',
                'label'         => esc_html__( 'Products per page', 'pistacia' ),
                'name'          => 'pistacia_o_shop_perpage',
                'instructions'  => 'Products per page',
                'required'      => 0,
                'type' => 'number',
                'min' => 1,
                'default_value' => 9,
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_shp2',
                'label'         => esc_html__( 'Shop products page aside layout', 'pistacia' ),
                'name'          => 'pistacia_o_shpprdcts_aside',
                'instructions'  => 'Shop products page aside layout left or right',
                'required'      => 0,
                'choices'      => array(
                    'left' => esc_html__('Left align','pistacia'),
                    'right' => esc_html__('Right align','pistacia'),
                ),
                'type' => 'select',
                'default_value' => 'left',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key' => 'field_pistacia_rcps0',
                'label' => esc_html__( 'Recipes', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key'           => 'field_pistacia_rcps1',
                'label'         => esc_html__( 'Recipe default columns', 'pistacia' ),
                'name'          => 'pistacia_o_recipes_columns',
                'instructions'  => 'Recipes columns',
                'required'      => 1,
                'choices'      => array(
                    '3' => '3 columns',
                    '4' => '4 columns',
                    '5' => '5 columns'
                ),
                'type' => 'select',
                'default_value' => '5',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_rcps2',
                'label'         => esc_html__( 'Recipe perpage', 'pistacia' ),
                'name'          => 'pistacia_o_recipes_perpage',
                'instructions'  => 'Recipes per page',
                'required'      => 1,
                'type' => 'number',
                'min' => 0,
                'default_value' => 5,
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_rcps3',
                'label'         => esc_html__( 'Recipe difficulty symbol', 'pistacia' ),
                'name'          => 'pistacia_o_recipes_diff_symbol',
                'instructions'  => 'Recipes difficulty symbols icon',
                'required'      => 0,
                'choices'      => Pistacia_Icons::get_pistacia_all_icons(),
                'type' => 'select',
                'default_value' => '',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_rcps4',
                'label'         => esc_html__( 'Recipe methode title text', 'pistacia' ),
                'name'          => 'pistacia_o_recipes_methode_text',
                'instructions'  => 'Default text: Methode',
                'required'      => 0,
                'type'          => 'text',
                'default_value' => '',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key' => 'field_pistacia_ptns7',
                'label' => esc_html__( 'Social', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left',
                'style' => 'pistacia-options'
            ),
            array(
                'key' => 'field_pistacia_ptns8',
                'label' => esc_html__( 'Facebook splash image', 'pistacia' ),
                'name' => 'pistacia_facebook_splash_image',
                'type' => 'image',
                'instructions' => esc_html__( 'Upload a Facebook splash image. Size 640 x 360', 'pistacia' ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
            ),
            array(
                'key' => 'field_pistacia_ptns9',
                'label' => esc_html__( 'Facebook page link', 'pistacia' ),
                'name' => 'pistacia_social_facebook',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_ptns10',
                'label' => esc_html__( 'Facebook share button', 'pistacia' ),
                'name' => 'pistacia_social_facebook_shbutton',
                'type' => 'radio',
                'instructions' => esc_html__( 'Show facebook share button all post', 'pistacia' ),
                'default_value' => '0',
                'choices' => array(
                    '1' => esc_html__( 'Show', 'pistacia' ),
                    '0' => esc_html__( 'Hide', 'pistacia' ),
                ),
            ),
            array(
                'key' => 'field_pistacia_ptns11',
                'label' => esc_html__( 'Google plus page link', 'pistacia' ),
                'name' => 'pistacia_social_googleplus',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_ptns12',
                'label' => esc_html__( 'Google plus share button', 'pistacia' ),
                'name' => 'pistacia_social_googleplus_shbutton',
                'instructions' => esc_html__( 'Show google plus share button all post', 'pistacia' ),
                'type' => 'radio',
                'default_value' => '0',
                'choices' => array(
                    '1' => esc_html__( 'Show', 'pistacia' ),
                    '0' => esc_html__( 'Hide', 'pistacia' ),
                ),
            ),
            array(
                'key' => 'field_pistacia_ptns13',
                'label' => esc_html__( 'Twitter link', 'pistacia' ),
                'name' => 'pistacia_social_twitter',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_ptns14',
                'label' => esc_html__( 'Twitter share button', 'pistacia' ),
                'name' => 'pistacia_social_twitter_shbutton',
                'type' => 'radio',
                'instructions' => esc_html__( 'Show twitter share button all post', 'pistacia' ),
                'default_value' => '0',
                'choices' => array(
                    '1' => esc_html__( 'Show', 'pistacia' ),
                    '0' => esc_html__( 'Hide', 'pistacia' ),
                ),
            ),
            array(
                'key'=> 'field_pistacia_ptns15',
                'label' => esc_html__( 'Youtube link', 'pistacia' ),
                'name' => 'pistacia_social_youtube',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_ptns16',
                'label' => esc_html__( 'Skype link', 'pistacia' ),
                'name' => 'pistacia_social_skype',
                'type' => 'text'
            ),

            array(
                'key' => 'field_pistacia_cntcts1',
                'label' => esc_html__( 'Contacts', 'pistacia' ),
                'type' => 'tab'
            ),
            array(
                'key' => 'field_pistacia_cntcts3',
                'label' => esc_html__( 'Contact email', 'pistacia' ),
                'name' => 'pistacia_contact_email',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_cntcts4',
                'label' => esc_html__( 'Contact address', 'pistacia' ),
                'name' => 'pistacia_contact_address',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_cntcts5',
                'label' => esc_html__( 'Contact phone', 'pistacia' ),
                'name' => 'pistacia_contact_phone',
                'type' => 'text'
            ),
            array(
                'key' => 'field_pistacia_cntcts6',
                'label' => esc_html__( 'Operation times', 'pistacia' ),
                'name' => 'pistacia_op_times',
                'type' => 'repeater',
                'min' => '',
                'button_label' => esc_html__( 'Add Operation time', 'pistacia' ),
                'instructions' => esc_html__( 'You can add operation times. Use add item button on right', 'pistacia' ),
                'layout' => 'row',
                'sub_fields' => array(
                    array(
                        'key' => 'field_pistacia_cntcts7',
                        'label' => esc_html__( 'Title', 'pistacia' ),
                        'name' => 'pistacia_op_time_title',
                        'type' => 'text',
                        'instructions' => esc_html__( 'Type operation time title', 'pistacia' ),
                        'required' => 0,
                        'default_value'=> esc_html__('Monday to thuesday','pistacia')
                    ),
                    array(
                        'key' => 'field_pistacia_cntcts8',
                        'label' => esc_html__( 'Operation time', 'pistacia' ),
                        'name' => 'pistacia_op_time_time',
                        'type' => 'text',
                        'instructions' => esc_html__( 'Type operation time', 'pistacia' ),
                        'required' => 0,
                        'default_value'=> '12:00-16:00'
                    ),
                )
            ),
            array(
                'key' => 'field_pistacia_rrpg0',
                'label' => esc_html__( 'Errors', 'pistacia' ),
                'type' => 'tab',
                'placement' => 'left'
            ),
            array(
                'key' => 'field_pistacia_rrpg3',
                'label' => esc_html__( '404 error image', 'pistacia' ),
                'name' => 'pistacia_404_error_img',
                'type' => 'image',
                'preview_size' => 'thumbnail',
                'return_format' => 'url',
            ),
            array(
                'key' => 'field_pistacia_rrpg1',
                'label' => esc_html__( '404 error title', 'pistacia' ),
                'name' => 'pistacia_404_error_title',
                'type' => 'text',
                'default_value' => esc_html__('We have got a problem!','pistacia')
            ),
            array(
                'key' => 'field_pistacia_rrpg2',
                'label' => esc_html__( '404 error subtitle', 'pistacia' ),
                'name' => 'pistacia_404_error_subtitle',
                'type' => 'text',
                'default_value' => esc_html__('Oops, This Page Could Not Be Found!','pistacia')
            ),
            array(
                'key' => 'field_pistacia_rwvs1',
                'label' => esc_html__( 'Testimonals', 'pistacia' ),
                'type' => 'tab'
            ),
            array(
                'key' => 'field_pistacia_rwvs2',
                'label' => esc_html__( 'Testimonals', 'pistacia' ),
                'name' => 'pistacia_reviews',
                'type' => 'repeater',
                'min' => '',
                'button_label' => esc_html__( 'Add reviews', 'pistacia' ),
                'instructions' => esc_html__( 'Use "Add reviews" button on right', 'pistacia' ),
                'layout' => 'row',
                'sub_fields' => array(
                    array(
                        'key' => 'field_pistacia_rwvs4',
                        'label' => esc_html__( 'Name', 'pistacia' ),
                        'name' => 'pistacia_review_name',
                        'type' => 'text',
                        'required' => 1
                    ),
                    array(
                        'key' => 'field_pistacia_rwvs3',
                        'label' => esc_html__( 'Testimonal', 'pistacia' ),
                        'name' => 'pistacia_review_desc',
                        'type' => 'text',
                        'required' => 1,
                        'maxlength' => '50'
                    ),
                    array(
                        'key' => 'field_pistacia_rwvs5',
                        'label' => esc_html__( 'Photo', 'pistacia' ),
                        'name' => 'pistacia_review_img',
                        'type' => 'image',
                        'preview_size' => 'thumbnail',
                        'return_format' => 'object',
                        'required' => 0,
                        'default_value' => esc_html__('Monday to thuesday','pistacia')
                    ),
                )
            ),
            array(
                'key' => 'field_pistacia_ptns21',
                'label' => esc_html__( 'Footer', 'pistacia' ),
                'type' => 'tab'
            ),
            array(
                'key'           => 'field_pistacia_ptns128',
                'label'         => esc_html__( 'Footer widgets hide', 'pistacia' ),
                'name'          => 'pistacia_o_footer_hide',
                'instructions'  => 'If you want hide footer widgets section',
                'required'      => 0,
                'type' => 'select',
                'choices'      => array(
                    'show' => 'Show',
                    'hide' => 'Hide'
                ),
                'default_value' => 'show',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key'           => 'field_pistacia_ptns129',
                'label'         => esc_html__( 'Footer copyright hide', 'pistacia' ),
                'name'          => 'pistacia_o_copyright_hide',
                'instructions'  => 'If you want hide footer copyright section',
                'required'      => 0,
                'type' => 'select',
                'choices'      => array(
                    'show' => 'Show',
                    'hide' => 'Hide'
                ),
                'default_value' => 'show',
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
            array(
                'key' => 'field_pistacia_ptns28',
                'label' => esc_html__( 'Footer background', 'pistacia' ),
                'name' => 'pistacia_footer_image',
                'instructions' => esc_html__( 'This image show in footer', 'pistacia' ),
                'type' => 'image',
                'preview_size' => 'medium',
                'return_format' => 'url',
                'required' => 0
            ),
            array(
                'key' => 'field_pistacia_ptns26',
                'label' => esc_html__( 'Footer widget title', 'pistacia' ),
                'name' => 'pistacia_footer_widget_title',
                'instructions' => esc_html__( 'This widget show in right side', 'pistacia' ),
                'type' => 'text',
                'required' => 0
            ),
            array(
                'key' => 'field_pistacia_ptns27',
                'label' => esc_html__( 'Footer widget text', 'pistacia' ),
                'name' => 'pistacia_footer_widget_text',
                'instructions' => esc_html__( 'This widget show in right side', 'pistacia' ),
                'type' => 'textarea',
                'required' => 0
            ),
            array(
                'key' => 'field_pistacia_ptns6',
                'label' => esc_html__( 'Copyright', 'pistacia' ),
                'name' => 'pistacia_copyright',
                'type' => 'text',
                'default_value' => ''
            ),
            array(
                'key'           => 'field_pistacia_ptns126',
                'label'         => esc_html__( 'Footer columns', 'pistacia' ),
                'name'          => 'pistacia_o_footer_col',
                'instructions'  => 'If you use WP widgets for footer then can setting columns. Default 4 columns.',
                'required'      => 0,
                'type' => 'number',
                'min' => 1,
                'max' => 4,
                'default_value' => 4,
                'allow_null'   => 0,
                'multiple'     => 0,
                'ui'           => 1,
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'pistacia_settings',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
    );

    acf_add_local_field_group( $args );

}

