<?php
/**
 * 404.php
 *
 * This file error page
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

get_header(); ?>

<section class="error-wrapper" id="errorWrapper">

    <div class="container">

        <div class="clearfix">
            <div class="col-md-12">

                <?php if ( function_exists('get_field') && get_field('pistacia_404_error_img','option') ) : ?>
                    <img class="center-block responsive" src="<?php echo esc_url( get_field('pistacia_404_error_img','option') ); ?>" alt="">
                <?php else:?>
                    <img class="center-block responsive" src="<?php echo get_template_directory_uri();?>/assets/img/404.png" alt="">
                <?php endif; ?>

                <span class="error-type">404</span>

                <?php if ( function_exists('get_field') && get_field('pistacia_404_error_title','option') ) : ?>
                    <h2 class="text-center">
                        <?php echo esc_html( get_field('pistacia_404_error_title','option') );?>
                    </h2>
                <?php else : ?>
                    <h2 class="text-center">
                        <?php esc_html_e('We have got a problem!','pistacia');?>
                    </h2>
                <?php endif; ?>

                <?php if ( function_exists('get_field') && get_field('pistacia_404_error_subtitle','option') ) : ?>
                    <h5 class="text-center">
                        <?php echo esc_html( get_field('pistacia_404_error_subtitle','option') );?>
                    </h5>
                <?php else : ?>
                    <h5 class="text-center">
                        <?php esc_html_e('Oops, This Page Could Not Be Found!','pistacia');?>
                    </h5>
                <?php endif; ?>

            </div>
        </div>

    </div>

</section>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer(); ?>
