<?php
/**
 * pistacia_recipe_manager.php
 *
 * This file Pistacia_Recipe_manager class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia_recipe_manager
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Recipe_Manager' ) )
{
    class Pistacia_Recipe_Manager
    {
        private static $instance;

        protected function __construct()
        {
            add_action( 'save_post', array($this,'save_recipe_all_time_meta'), 10, 3 );

            //add_action( 'save_post', array($this,'save_generate_tags_json'), 10, 3 );

            add_action( 'wp_ajax_pistacia_ajax_getrecipes', array($this,'ajax_getrecipes') );
            add_action( 'wp_ajax_nopriv_pistacia_ajax_getrecipes', array($this,'ajax_getrecipes') );

            add_action( 'wp_ajax_pistacia_ajax_submit_recipe', array($this,'ajax_submit_recipe') );
            add_action( 'wp_ajax_nopriv_pistacia_ajax_submit_recipe', array($this,'ajax_submit_recipe') );

            add_action('after_setup_theme',array($this,'pistacia_recipes_type'));

            add_action('init',array($this,'acf_pro_settings'));

            add_action('plugins_loaded', array(&$this, 'load_textdomain'));

            if ( !is_admin() ) {
                add_action( 'wp_enqueue_scripts', array($this,'recipe_manager_enqueue_scripts_styles') );
            }

        }


        public function acf_pro_settings(){
            if ( function_exists( 'acf_add_local_field_group' ) ) {

                register_field_group( array(
                    'key'                   => 'group_ps_rcpsprprts',
                    'title'                 => esc_html__( 'Recipe properties', 'pistacia_recipe_manager' ),
                    'fields'                => array(
                        array(
                            'key'      => 'field_ps_rcpsprprts0001',
                            'label'    => esc_html__( 'Difficulty', 'pistacia_recipe_manager' ),
                            'name'     => 'pistacia_recipe_skill',
                            'type'         => 'select',
                            'required'     => 1,
                            'choices'      => array(
                                '1' => 1,
                                '2' => 2,
                                '3' => 3,
                                '4' => 4,
                                '5' => 5
                            ),
                            'allow_null'   => 0,
                            'multiple'     => 0,
                            'ui'           => 1,
                            'instructions' => esc_html__('Difficulty of recipe','pistacia_recipe_manager'),
                        ),
                        array(
                            'key'      => 'field_ps_rcpsprprts0002',
                            'label'    => esc_html__( 'Servings', 'pistacia_recipe_manager' ),
                            'name'     => 'pistacia_recipe_serv',
                            'type'     => 'number',
                            'instructions' => esc_html__('Number of peoples','pistacia_recipe_manager'),
                            'required' => 1,
                        ),
                        array(
                            'key'      => 'field_ps_rcpsprprts0003',
                            'label'    => esc_html__( 'Prep time', 'pistacia_recipe_manager' ),
                            'name'     => 'pistacia_recipe_preptime',
                            'type'     => 'number',
                            'instructions' => esc_html__('Minutes','pistacia_recipe_manager'),
                            'required' => 1,
                        ),
                        array(
                            'key'      => 'field_ps_rcpsprprts0004',
                            'label'    => esc_html__( 'Cook time', 'pistacia_recipe_manager' ),
                            'name'     => 'pistacia_recipe_cooktime',
                            'type'     => 'number',
                            'instructions' => esc_html__('Minutes','pistacia_recipe_manager'),
                            'required' => 1,
                        ),
                        array(
                            'key'      => 'field_ps_rcpsprprts0005',
                            'label'    => esc_html__( 'Passive time', 'pistacia_recipe_manager' ),
                            'name'     => 'pistacia_recipe_passivetime',
                            'type'     => 'number',
                            'instructions' => esc_html__('Minutes','pistacia_recipe_manager'),
                            'required' => 1,
                        ),
                    ),
                    'location'              => array(
                        array(
                            array(
                                'param'    => 'post_type',
                                'operator' => '==',
                                'value'    => 'pistacia-recipes',
                            ),
                        ),
                    ),
                    'menu_order'            => 0,
                    'position'              => 'side',
                    'style'                 => 'default',
                    'label_placement'       => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen'        => array(

                    ),
                ) );

                register_field_group( array(
                    'key'                   => 'group_ps_rcpadv',
                    'title'                 => esc_html__( 'Recipe', 'pistacia_recipe_manager' ),
                    'fields'                => array(
                        array(
                            'key'          => 'field_ps_rcpadv0000',
                            'label'        => esc_html__( 'Author photo', 'pistacia_recipe_manager' ),
                            'name'         => 'pistacia_recipe_author_photo',
                            'type'         => 'image',
                            'return_format' => 'array',
                            'preview_size' => 'thumbnail',
                            'instructions' => esc_html__( 'You can add author photo.', 'pistacia_recipe_manager' ),
                        ),
                        array(
                            'key'          => 'field_ps_rcpadv0001',
                            'label'        => esc_html__( 'Author', 'pistacia_recipe_manager' ),
                            'name'         => 'pistacia_recipe_author',
                            'type'         => 'text',
                        ),
                        array(
                            'key'          => 'field_ps_rcpadv0002',
                            'label'        => esc_html__( 'Ingredients', 'pistacia_recipe_manager' ),
                            'name'         => 'pistacia_ingr_items',
                            'type'         => 'repeater',
                            'min'          => '1',
                            'button_label' => esc_html__( 'Add ingredients', 'pistacia_recipe_manager' ),
                            'instructions' => esc_html__( 'You can add ingredients for this recipe. Use add item button on right', 'pistacia_recipe_manager' ),
                            'layout'       => 'table',
                            'sub_fields'   => array(

                                array(
                                    'key'      => 'field_ps_rcpadv0003',
                                    'label'    => esc_html__( 'Ingredient', 'pistacia_recipe_manager' ),
                                    'name'     => 'pistacia_ingr_name',
                                    'type'     => 'text',
                                    'placeholder' => esc_html__('Ingredient item name','pistacia_recipe_manager'),
                                    'required' => 1,
                                ),

                                array(
                                    'key'      => 'field_ps_rcpadv0004',
                                    'label'    => esc_html__( 'Weight', 'pistacia_recipe_manager' ),
                                    'name'     => 'pistacia_ingr_weight',
                                    'type'     => 'number',
                                    'placeholder' => esc_html__('Weight','pistacia_recipe_manager'),
                                    'required' => 0,
                                ),

                                array(
                                    'key'      => 'field_ps_rcpadv0005',
                                    'label'    => esc_html__( 'Measurement', 'pistacia_recipe_manager' ),
                                    'name'     => 'pistacia_ingr_mea',
                                    'type'     => 'text',
                                    'placeholder' => esc_html__('Kg, ml, clove etc.','pistacia_recipe_manager'),
                                    'required' => 0,
                                ),

                            )
                        ),
                        array(
                            'key'          => 'field_ps_rcpadv0006',
                            'label'        => esc_html__( 'Methode', 'pistacia_recipe_manager' ),
                            'name'         => 'pistacia_recipe_methode',
                            'type'         => 'wysiwyg',
                            'tabs'         => 'all',
                            'toolbar'      => 'full',
                            'media_upload' => 0,
                        ),

                        array(
                            'key'          => 'field_ps_rcpadv0007',
                            'label'        => esc_html__( 'Gallery', 'pistacia_recipe_manager' ),
                            'name'         => 'pistacia_recipe_gallery',
                            'type'         => 'gallery',
                        ),

                    ),
                    'location'              => array(
                        array(
                            array(
                                'param'    => 'post_type',
                                'operator' => '==',
                                'value'    => 'pistacia-recipes',
                            ),
                        ),
                    ),
                    'menu_order'            => 0,
                    'position'              => 'normal',
                    'style'                 => 'default',
                    'label_placement'       => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen'        => array(

                    ),
                ) );

            }
        }

        function load_textdomain()
        {
            load_theme_textdomain('pistacia__recipe_manager', PISTACIA_RECIPE_MANAGER_PLUGIN_DIR . '/lang');
        }

        /**
         * @return mixed|string|void
         */
        private function get_tags_json(){

            $terms = array();
            $tags = get_terms( array(
                'taxonomy' => 'pistacia-recipes-tags',
                'orderby'    => 'name',
                'hide_empty' => false
            ) );

            foreach($tags as $tag){

                array_push($terms,array(
                        'value' => $tag->term_id,
                        'text' => $tag->name )
                );
            }

            return json_encode($terms);

        }


        public function save_generate_tags_json( $post_id, $post, $update )
        {

            if ( 'pistacia-recipes' != $post->post_type ) {
                return;
            }

            $access_type = get_filesystem_method();

            if( $access_type === 'direct' ) {
                $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, array());

                if ( ! WP_Filesystem($creds) ) {
                    return false;
                }

                global $wp_filesystem;

                $tags_json = $this->get_tags_json();
                $json_file = get_template_directory() . '/jsons/pistacia_recipes_tags.json';

                if ( !empty($tags_json) ){

                    if( !$wp_filesystem->is_dir( get_template_directory() . '/jsons/') ) {
                        $wp_filesystem->mkdir( get_template_directory() . '/jsons/');
                    } else {
                        $wp_filesystem->delete( $json_file );
                    }

                    $wp_filesystem->put_contents(
                        $json_file,
                        $tags_json,
                        FS_CHMOD_FILE
                    );

                }

            }

        }

        public function recipe_manager_enqueue_scripts_styles()
        {

            wp_enqueue_script(
                'pistacia-recipe-manager-js',
                PISTACIA_RECIPE_MANAGER_PLUGIN_URI . 'assets/js/pistacia-recipe-manager.min.js',
                array('jquery','pistacia-vendors-js'),
                '1.6.7',
                true
            );

            wp_localize_script(
                'pistacia-recipe-manager-js',
                'pistacia_recipe_manager_localize',
                array(
                    'ajax_url' => esc_url( admin_url( 'admin-ajax.php' ) ),
                    'get_template_directory_uri' => esc_url( get_template_directory_uri() ),
                    'get_template_directory' => esc_url( get_template_directory() ),
                    'sumbit_success_text' => esc_html__('Success message','pistacia_recipe_manager'),
                    'pistacia_recipes_tags_json_exist' => ( file_exists( get_template_directory() . '/jsons/pistacia_recipes_tags.json' ) ) ? true : false
                ));

            wp_enqueue_style(
                'pistacia-recipe-manager',
                esc_url( PISTACIA_RECIPE_MANAGER_PLUGIN_URI ) . 'assets/css/pistacia-recipe-manager.min.css',
                array(),
                '1.6.7',
                'all'
            );

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }


        /**
         * pistacia_recipes_type
         *
         * Custom post type ( Recipes )
         *
         * supports
         * title
         * editor (content)
         * author
         * thumbnail (featured image) (current theme must also support Post Thumbnails)
         * excerpt
         * trackbacks
         * custom-fields (see Custom_Fields, aka meta-data)
         * comments (also will see comment count balloon on edit screen)
         * revisions (will store revisions)
         * page-attributes (template and menu order) (hierarchical must be true)
         * post-formats (see Post_Formats)
         *
         * @param void
         * @return void
         *
         * */
        public function pistacia_recipes_type(){

            register_post_type('pistacia-recipes',array(
                'labels' => array('name' => esc_html__('Recipes','pistacia_recipe_manager')),
                'supports' => array('title','excerpt','comments','revisions','thumbnail'),
                'public' => true,
                'menu_icon' => 'dashicons-edit',
                'menu_position' => 6,
            ));

            register_taxonomy('pistacia-recipes-categories','pistacia-recipes',array(
                'hierarchical' => true,
                'label' => esc_html__('Recipe categories','pistacia_recipe_manager'),
                'query_var' => true
            ));

            register_taxonomy('pistacia-recipes-cousines','pistacia-recipes',array(
                'hierarchical' => true,
                'label' => esc_html__('Recipe cousine','pistacia_recipe_manager'),
                'query_var' => true
            ));

            register_taxonomy('pistacia-recipes-tags','pistacia-recipes',array(
                'hierarchical' => false,
                'label' => esc_html__('Recipe tags','pistacia_recipe_manager'),
                'query_var' => true
            ));

        }

        /**
         * If save or update recipe add or update pistacia_recipe_alltime custom post meta
         * pistacia_recipe_alltime meta = Preparation time + Cook time + Passive time
         * @param $post_id
         * @param $post
         * @param $update
         */
        public function save_recipe_all_time_meta( $post_id, $post, $update )
        {
            $slug = 'pistacia-recipes';

            if ( $slug != $post->post_type ) {
                return;
            }

            $alltime = 0;

            /**Preptime**/
            if ( isset( $_REQUEST['acf']['field_ps_rcpsprprts0003'] ) ) {
                $alltime = $alltime + (int) $_REQUEST['acf']['field_ps_rcpsprprts0003'];
            }

            /**Passivetime**/
            if ( isset( $_REQUEST['acf']['field_ps_rcpsprprts0005'] ) ) {
                $alltime = $alltime + (int) $_REQUEST['acf']['field_ps_rcpsprprts0005'];
            }

            /**Cooktime**/
            if ( isset( $_REQUEST['acf']['field_ps_rcpsprprts0004'] ) ) {
                $alltime = $alltime + (int) $_REQUEST['acf']['field_ps_rcpsprprts0004'];
            }

            if ( ! add_post_meta( $post_id, 'pistacia_recipe_alltime', (int)$alltime , true ) ) {
                update_post_meta($post_id, 'pistacia_recipe_alltime', (int)$alltime);
            }

        }

        /**
         * pistacia_the_favourite_button
         */
        public function the_favourite_button(){ ?>
            <a href="#" class="recipe-favourites-btn<?php echo (!empty($_COOKIE['pistacia-recipes-favourites'])) ? ' active' : '';?>" id="recipe-favourites-btn"><i class="fa fa-heart"></i> <?php esc_html_e('Favourites','pistacia_recipe_manager');?></a>
        <?php }


        /**
         * the_most_recipes_posts
         *
         * @param array $args
         */
        public function the_most_recipes_posts( $args = array() ){?>

            <?php $loop = new WP_Query( $args ); ?>

            <?php if( $loop->have_posts() ) : ?>

                <ul>

                    <?php while( $loop->have_posts()): $loop->the_post(); ?>

                        <?php $thumb_src = wp_get_attachment_image_src(get_post_thumbnail_id( $loop->get_the_ID() ), 'thumbnail'); ?>

                        <li>
                            <div class="widget-photo">
                                <a href="<?php the_permalink();?>"><img src="<?php echo esc_url($thumb_src[0]);?>" class="img-responsive"></a>
                            </div>
                            <div class="widget-text">

                                <a href="<?php the_permalink();?>" class="title"><?php the_title(); ?></a>

                                <?php if( !empty( $args['orderby'] ) && $args['orderby'] == 'date' ) : ?>
                                    <span class="entry-date"><i class="fa fa-calendar"></i> <?php echo esc_html(get_the_date()); ?> <?php echo get_the_time(); ?></span>
                                <?php endif; ?>

                                <?php if( !empty( $args['meta_query'] ) && array_key_exists('pistacia_recipe_cooktime',$args['meta_query']) ) : ?>
                                    <?php if ( function_exists('get_field') ) : ?>
                                        <?php $alltime = (int)get_field('pistacia_recipe_alltime'); ?>
                                        <span class="entry-time"><i class="fa fa-clock-o"></i> <?php echo esc_html($alltime)?> mins</span>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if( !empty($args['meta_key']) && $args['meta_key']=='pistacia_recipe_skill') : ?>
                                    <?php $icon = ( function_exists('get_field') && get_field('pistacia_o_recipes_diff_symbol','option') ) ? get_field('pistacia_o_recipes_diff_symbol','option') : 'flaticon-meal2'; ?>
                                    <div class="difficulty">
                                        <?php esc_html_e('Difficulty','pistacia_recipe_manager');?> :
                                        <?php for( $a=1; $a<= 5; $a++ ) : ?>
                                            <i class="<?php echo esc_attr($icon);?><?php echo ( $a <= (int)get_field('pistacia_recipe_skill')) ? ' active' : ''; ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </li>

                    <?php endwhile; ?>

                </ul>

            <?php endif; ?>

            <?php wp_reset_postdata(); ?>

        <?php }


        public function the_recent_recipes( $title = '', $box_style, $args = array() ){?>

            <?php $loop = new WP_Query( $args ); ?>

            <?php if( $loop->have_posts() ) : ?>

                <div class="popular-widget clearfix <?php echo esc_html($box_style); ?>">

                    <?php if ( $title != '' ) : ?>
                        <h3 class="headline"><span><?php echo esc_html( $title );?></span></h3>
                    <?php endif; ?>

                    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>

                        <article class="item row">

                            <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'thumbnail' ); ?>

                            <?php if ( !empty( $img_url ) ):?>
                                <div class="col-md-4">
                                    <a href="<?php the_permalink();?>">
                                        <figure class="figure-hubba">
                                            <img src="<?php echo esc_url($img_url[0]);?>" class="img-responsive wait-for-load" alt="">
                                            <figcaption class="figcaption">
                                                <span class="icon"><i class="fa fa-search"></i></span>
                                            </figcaption>
                                        </figure>
                                    </a>
                                </div>
                            <?php endif; ?>


                            <div class="col-md-<?php echo (!empty( $img_url ) ) ? '8' : '12'; ?>">

                                <span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                                
                                <h1><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h1>

                                <?php $icon = ( function_exists('get_field') && get_field('pistacia_o_recipes_diff_symbol','option') ) ? get_field('pistacia_o_recipes_diff_symbol','option') : 'flaticon-meal2'; ?>
                                <div class="difficulty">
                                    <?php esc_html_e('Difficulty','pistacia_recipe_manager');?> :
                                    <?php for( $a=1; $a<= 5; $a++ ) : ?>
                                        <i class="<?php echo esc_attr($icon);?><?php echo ( $a <= (int)get_field('pistacia_recipe_skill')) ? ' active' : ''; ?>"></i>
                                    <?php endfor; ?>
                                </div>

                                <a href="<?php the_permalink();?>"><?php esc_html_e('more','pistacia');?></a>

                            </div>

                        </article>

                    <?php endwhile; ?>

                </div>

            <?php endif; ?>

            <?php wp_reset_postdata(); ?>

        <?php }


        public function ajax_submit_recipe()
        {

            if ( !empty( $_POST['action'] ) && $_POST['action'] == "pistacia_ajax_submit_recipe"){

                $pistacia_recipe = new Pistacia_Recipe();

                /*
                $xxxx = array(
                    'title' => null,
                    'methode' => null,
                    'author_photo' =>null,
                    'author_name' => null,
                    'excerpt' => null,
                    'skill' => null,
                    'servings' => null,
                    'prep_time' => null,
                    'cook_time' => null,
                    'passive_time' => null,
                    'ingredients' => array(),
                    'attachment_src' => array(),
                    'secondary_src' => null,
                    'tags'=> array(),
                    'categories' => array(),
                    'cousine' => array(),
                    'gallery' => array(),
                    'post' => null
                );*/

                $unique_id = $_POST['unique_id'];
                $post_title = $_POST[ 'sbmt-recipe-title-' . $unique_id ];
                $post_excerpt = $_POST[ 'sbmt-recipe-excerpt-' . $unique_id ];
                $recipe_tags = $_POST[ 'sbmt-recipe-tags-' . $unique_id ];
                $recipe_categories = $_POST[ 'sbmt-recipe-categories-' . $unique_id ];
                $recipe_cousines = $_POST[ 'sbmt-recipe-cousines-' . $unique_id ];

                //TODO pistacia_recipe->valid_submit_params return value
                if ( $pistacia_recipe->valid_submit_params( ) ){

                    /* Insert post */
                    $args = array(
                        'post_type' => 'pistacia-recipes',
                        'post_title' => wp_strip_all_tags( $post_title ),
                        'post_status' => 'publish',
                        'post_excerpt' => wp_strip_all_tags( $post_excerpt )
                    );

                    $recipe_id = wp_insert_post( $args, $wp_error );

                    /* Insert categories tags and cousines */
                    if ( !empty( $recipe_id ) ){

                        if (!empty($recipe_tags)){
                            wp_set_post_terms( $recipe_id, array_map('intval',explode(',',$recipe_tags)), 'pistacia-recipes-tags' );
                        }

                        if (!empty($recipe_cousines)){
                            wp_set_post_terms( $recipe_id, array_map('intval',$recipe_cousines), 'pistacia-recipes-cousines' );
                        }

                        if (!empty($recipe_categories)){
                            wp_set_post_terms( $recipe_id, array_map('intval',$recipe_categories), 'pistacia-recipes-categories' );
                        }

                    }

                    /* Insert featured image */

                    if ( !empty( $recipe_id ) ) {

                        $filename = $_POST['featured_img'];
                        $parent_post_id = $recipe_id;
                        $filetype = wp_check_filetype( basename( $filename ), null );
                        $wp_upload_dir = wp_upload_dir();

                        print($filename);


                        $attachment = array(
                            'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
                            'post_mime_type' => $filetype['type'],
                            'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
                            'post_content'   => '',
                            'post_status'    => 'inherit'
                        );

                        //print_r($attachment);
                        //$attach_id = wp_insert_attachment( $attachment, $filename, $parent_post_id );
                        //require_once( ABSPATH . 'wp-admin/includes/image.php' );
                        //$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
                        //wp_update_attachment_metadata( $attach_id, $attach_data );
                        //set_post_thumbnail( $parent_post_id, $attach_id );

                    }



                    /* Insert secondary image */

                    /* Insert properties serving, difficulty, cook time etc. */

                    /* Insert author and author photo */

                    /* Insert methode */

                    /* Insert ingredients */

                    /* Insert gallery */



                }
            }

            die();
        }


        /**
         * pistacia_ajax_getrecipes
         *
         * Get recipes with ajax
         *
         */
        public function ajax_getrecipes(){?>

            <?php $args = array();
            $spl = explode(',',$_POST['args']);
            foreach ( $spl as $value){

                $v = explode( '=', $value );

                if ($v[0] == 'tax_query'){

                    $t = explode( ';', $v[1] );

                    if ( count($t) > 3){
                        $chunked = array_chunk($t,3);
                        $args['tax_query']['relation'] = 'AND';
                        $a = 0;
                        foreach($chunked as $k){
                            $a++;
                            $args['tax_query'][1][$a]['taxonomy'] = $k[0];
                            $args['tax_query'][1][$a]['field'] = $k[2];
                            $args['tax_query'][1][$a]['terms'] = $k[1];
                        }
                    } else {
                        $args['tax_query'][0][0]['taxonomy'] = $t[0];
                        $args['tax_query'][0][0]['field'] = $t[2];
                        $args['tax_query'][0][0]['terms'] = $t[1];
                    }

                } else{
                    $params = explode(';',$v[1]);
                    if (count($params)==1) {
                        if ($v[0] == 'post__in'){
                            $args[$v[0]] = array($v[1]);
                        }else {
                            $args[$v[0]] = $v[1];
                        }
                    } else{
                        $args[$v[0]] = $params;
                    }
                }
            } ?>

            <?php $loop = new WP_Query( $args ); ?>

            <span class="recipes-data" data-found-posts="<?php echo $loop->found_posts; ?>"></span>

            <?php if( $loop->have_posts() ) : ?>

                <?php while( $loop->have_posts()): $loop->the_post(); ?>

                    <?php get_template_part('partials/element-recipe-box'); ?>

                <?php endwhile; ?>

            <?php endif; ?>

            <?php wp_reset_postdata(); ?>

            <?php die(); ?>

        <?php }

    }

}