<?php /**
 * recipe.php
 *
 * This file contains recipe
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia_recipe_manager
 * @since          pistacia_recipe_manager 1.3.0
 */ ?>

<?php if ( !class_exists('pistacia_recipe') ) {

    class Pistacia_Recipe
    {
        private $recipe = array(
            'id' => null,
            'title' => null,
            'date' => null,
            'methode' => null,
            'author_photo' =>null,
            'author_name' => null,
            'excerpt' => null,
            'skill' => null,
            'servings' => null,
            'prep_time' => null,
            'cook_time' => null,
            'passive_time' => null,
            'ingredients' => array(),
            'attachment_src' => array(),
            'secondary_src' => null,
            'tags'=> array(),
            'categories' => array(),
            'cousine' => array(),
            'gallery' => array(),
            'post' => null
        );

        public function __construct() {}


        public function set_recipe( $id )
        {

            $post = get_post( $id );

            $this->recipe['id'] = $id;
            $this->recipe['post'] = $post;
            $this->recipe['title'] = $post->post_title;
            $this->recipe['excerpt'] = $post->post_excerpt;
            $this->recipe['date'] = $post->post_date;

            $large_src = wp_get_attachment_image_src(get_post_thumbnail_id( $id ), 'large');
            $this->recipe['attachment_src']['large'] = $large_src[0];

            if ( function_exists('get_field') ) {

                if ( get_field('ps_header_img') ){
                    $head_src = get_field('ps_header_img');
                }

                if ( get_field('pistacia_recipe_skill') ){
                    $this->recipe['skill'] = get_field('pistacia_recipe_skill');
                }

                if ( get_field('pistacia_recipe_serv') ){
                    $this->recipe['servings'] = get_field('pistacia_recipe_serv');
                }

                if ( get_field('pistacia_recipe_preptime') ){
                    $this->recipe['prep_time'] = get_field('pistacia_recipe_preptime');
                }

                if ( get_field('pistacia_recipe_cooktime') ){
                    $this->recipe['cook_time'] = get_field('pistacia_recipe_cooktime');
                }

                if ( get_field('pistacia_recipe_passivetime') ){
                    $this->recipe['passive_time'] = get_field('pistacia_recipe_passivetime');
                }

                if ( get_field('pistacia_recipe_author_photo') ){
                    $this->recipe['author_photo'] = get_field('pistacia_recipe_author_photo');
                }

                if ( get_field('pistacia_recipe_author') ){
                    $this->recipe['author_name'] = get_field('pistacia_recipe_author');
                }

                if ( get_field('pistacia_recipe_gallery') ){
                    $this->recipe['gallery'] = get_field('pistacia_recipe_gallery');
                }

                if ( get_field('pistacia_recipe_methode') ){
                    $this->recipe['methode'] = get_field('pistacia_recipe_methode');
                }

                if ( get_field('pistacia_ingr_items') ){
                    $this->recipe['ingredients'] = get_field('pistacia_ingr_items');
                }

            }

            $this->recipe['secondary_src'] = ( !empty( $head_src ) ) ? $head_src : Pistacia_Helpers::get_template_directory_uri() . '/assets/img/footer_background.jpg';

        }


        public function the_title()
        {?>
            <?php if ( !empty($this->recipe['title']) ) : ?>
            <h1 class="title"><?php echo esc_html( $this->recipe['title'] ); ?></h1>
        <?php endif; ?>

        <?php }


        public function valid_submit_params( )
        {
            return true;
        }


        public function the_excerpt()
        { ?>
            <?php if ( !empty($this->recipe['excerpt']) ) : ?>
            <div class="excerpt">
                <?php //echo wp_trim_words(esc_html($this->recipe['excerpt']), 40, ' ...'); ?>
                <?php echo esc_html($this->recipe['excerpt']); ?>
            </div>
        <?php endif; ?>
        <?php }


        public function the_recipe_props()
        {?>

            <?php if ( !empty($this->recipe['servings']) || !empty($this->recipe['prep_time']) || !empty($this->recipe['cook_time']) || !empty($this->recipe['passive_time']) ):?>
            <ul class="recipe-properties">
                <?php if ( !empty($this->recipe['servings']) ) : ?>
                    <li><i class="fa fa-user"></i> <span><?php esc_html_e('Serving','pistacia_recipe_manager'); ?>:</span> <?php echo esc_html($this->recipe['servings']); ?></li>
                <?php endif; ?>
                <?php if ( !empty($this->recipe['prep_time']) ) : ?>
                    <li><i class="fa fa-clock-o"></i> <span><?php esc_html_e('Preparation','pistacia_recipe_manager'); ?>:</span> <?php echo esc_html($this->recipe['prep_time']); ?></li>
                <?php endif; ?>
                <?php if ( !empty($this->recipe['cook_time']) ) : ?>
                    <li><i class="fa fa-clock-o"></i> <span><?php esc_html_e('Cook time','pistacia_recipe_manager'); ?>:</span> <?php echo esc_html($this->recipe['cook_time']); ?></li>
                <?php endif; ?>
                <?php if ( !empty($this->recipe['passive_time']) ) : ?>
                    <li><i class="fa fa-clock-o"></i> <span><?php esc_html_e('Passive time','pistacia_recipe_manager'); ?>:</span> <?php echo esc_html($this->recipe['passive_time']); ?></li>
                <?php endif; ?>
            </ul>
        <?php endif; ?>

        <?php }


        public function the_recipe_difficulty()
        {?>
            <?php if ( !empty($this->recipe['skill']) ):?>
            <?php $icon = (function_exists('get_field') && (get_field('pistacia_o_recipes_diff_symbol','option') ) ) ? get_field('pistacia_o_recipes_diff_symbol','option') : 'flaticon-meal2'; ?>
            <ul class="recipe-info-list">
                <li class="difficulty">
                    <span><?php esc_html_e('Difficulty','pistacia_recipe_manager'); ?>:</span>
                    <?php for( $a=1; $a<= 5; $a++ ) : ?>
                        <i class="<?php echo esc_attr($icon);?><?php echo ( $a <= (int)$this->recipe['skill'] ) ? ' active' : ''; ?>"></i>
                    <?php endfor; ?>
                </li>
            </ul>
        <?php endif; ?>
        <?php }


        public function the_recipe_author()
        {?>
            <?php if ( !empty($this->recipe['author_name']) || !empty($this->recipe['author_photo']) ):?>
            <div class="clearfix">
                <?php if ( !empty($this->recipe['author_photo']) ) : ?>
                    <?php $author_img_src = $this->recipe['author_photo']; ?>
                    <img src="<?php echo esc_url( $author_img_src['sizes']['thumbnail'] ); ?>" class="recipe-author-photo img-responsive img-circle" alt="">
                <?php endif; ?>
                <?php if ( !empty($this->recipe['author_name']) ) : ?>
                    <span class="recipe-author-name"><?php esc_html_e('by','pistacia_recipe_manager');?>: <?php echo esc_html($this->recipe['author_name']); ?></span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php }


        /**
         * @return mixed
         */
        public function get_head_src()
        {
            return $this->recipe['secondary_src'];
        }

        /**
         * @param string $size
         * @return mixed
         */
        public function get_attachment_scr( $size = 'large' )
        {
            if ( !empty($this->recipe['attachment_src'][$size]) ) {
                return $this->recipe['attachment_src'][$size];
            }
        }

        /**
         * @return mixed
         */
        public function get_recipe_id()
        {
            return $this->recipe['id'];
        }


        public function the_methode_box()
        {?>
            <?php if ( $this->recipe['methode'] ) : ?>
            <div class="recipe-methode-box">
                <div class="recipe-methode-inner">
                    <?php $title = (function_exists('get_field') && get_field('pistacia_o_recipes_methode_text','option') ) ? get_field('pistacia_o_recipes_methode_text','option') : esc_html__('Methode','pistacia_recipe_manager'); ?>
                    <h1 class="title"><?php echo esc_html($title);?></h1>
                    <?php echo wp_kses_post($this->recipe['methode']); ?>
                </div>
            </div>
        <?php endif; ?>
        <?php }


        public function the_ingredients_box()
        {?>

            <?php if ( !empty( $this->recipe['ingredients'] ) ) : ?>
            <div class="recipe-ingredients-box">
                <div class="recipe-ingredients-inner">
                    <h1 class="title"><?php esc_html_e('Ingredients','pistacia_recipe_manager'); ?></h1>
                    <ul class="recipe-ingredients">
                        <?php foreach( $this->recipe['ingredients'] as $ingr ) : ?>
                            <li>
                                <span class="ingr-weight"><?php echo esc_html($ingr['pistacia_ingr_weight']); ?></span>
                                <span class="ingr-mea"><?php echo esc_html($ingr['pistacia_ingr_mea']); ?></span>
                                <span class="ingr-name"><?php echo esc_html($ingr['pistacia_ingr_name']); ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php }

        public function the_recipe_gallery_box()
        {?>

            <?php if ( !empty($this->recipe['gallery']) ) : ?>
            <div class="recipe-gallery-box">
                <div class="recipe-gallery-inner">
                    <h1 class="title"><?php esc_html_e('Gallery','pistacia_recipe_manager'); ?></h1>

                    <ul class="gallery-items clearfix">
                        <?php foreach( $this->recipe['gallery'] as $photo ) : ?>
                            <li class="item">
                                <figure class="figure-hubba">
                                    <img src="<?php echo esc_url($photo['sizes']['thumbnail']); ?>" class="img-responsive wait-for-load" alt="">
                                    <figcaption class="figcaption">
                                        <a href="<?php echo esc_url($photo['url']); ?>" class="icon swipebox"><i class="fa fa-search"></i></a>
                                    </figcaption>
                                </figure>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php }

        /**
         * the_recipe_tags_box
         *
         * display recipe tags
         */
        public function the_recipe_tags_box()
        { ?>
            <?php if ( !empty($this->recipe['id']) ) : ?>
            <?php $terms = get_the_terms( $this->get_recipe_id(), 'pistacia-recipes-tags' ); ?>
            <?php if ( !empty($terms) && ! is_wp_error($terms)) : ?>
                <div class="recipe-tags-box hidden-print">
                    <div class="recipe-tags-inner">
                        <h1 class="title"><?php esc_html_e('Recipe tags','pistacia_recipe_manager');?></h1>
                        <ul class="tags clearfix">
                            <?php foreach ( $terms as $term ) {?>
                                <li>
                                    <a href="<?php echo esc_url(get_term_link( $term ));?>"><?php echo esc_html($term->slug);?></a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        <?php }


        /**
         * the_recipe_categories_box
         *
         * display recipe category and cousine
         */
        public function the_recipe_categories_box() { ?>

            <?php if ( !empty($this->recipe['id']) ) : ?>

                <?php $cousine = get_the_terms( $this->get_recipe_id(), 'pistacia-recipes-cousines' ); ?>
                <?php $category = get_the_terms( $this->get_recipe_id(), 'pistacia-recipes-categories' );?>

                <?php if ( !empty( $cousine ) || !empty( $category ) ) : ?>

                    <div class="recipe-categories-box hidden-print">

                        <div class="recipe-categories-inner clearfix">

                            <?php if ( !empty($cousine) && ! is_wp_error($cousine)) : ?>
                                <h3 class="title"><?php esc_html_e('Cousine','pistacia_recipe_manager');?>: </h3>
                                <ul class="categories-list">
                                    <?php foreach ( $cousine as $term ) {?>
                                        <li>
                                            <a href="<?php echo esc_url(get_term_link( $term ));?>"><?php echo esc_html($term->slug);?></a>
                                        </li>
                                    <?php } ?>
                                </ul>

                            <?php endif; ?>

                            <?php if ( !empty($category) && ! is_wp_error($category)) :?>

                                <h3 class="title"><?php esc_html_e('Category','pistacia_recipe_manager');?>: </h3>
                                <ul class="categories-list">
                                    <?php foreach ( $category as $term ) {?>
                                        <li>
                                            <a href="<?php echo esc_url(get_term_link( $term ));?>"><?php echo esc_html($term->slug);?></a>
                                        </li>
                                    <?php } ?>
                                </ul>

                            <?php endif; ?>

                            <a href="#" class="recipe-print-btn"><i class="fa fa-print"></i></a>

                        </div>
                    </div>

                <?php endif; ?>

            <?php endif; ?>

        <?php }

    }

}
