<?php
/**
 * Plugin Name: Pistacia Menu Manager
 * Plugin URI: http://wp.pistaciatheme.com/pistacia
 * Description: You can management food menus in Pistacia theme
 * Version: 1.6.7
 * Author: Pistaciatheme
 * Author URI: http://themeforest.net/user/pistaciatheme
 * License: GPL-3.0
 * Plugin textdomain: pistacia_menu_manager
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define('PISTACIA_MENU_MANAGER_PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('PISTACIA_MENU_MANAGER_PLUGIN_URI', plugin_dir_url( __FILE__ ));

/**
 * Class autoloader
 */
function pistacia_menu_autoloader( $className )  {
    $file = plugin_dir_path( __FILE__ ) . '/class/' . strtolower($className) . '.php';
    if( file_exists( $file ) ) {
        require_once( $file );
    }
}

spl_autoload_register('pistacia_menu_autoloader');


$GLOBALS['pistacia_menu_manager'] = Pistacia_Menu_Manager::get_instance();