<?php
/**
 * Plugin Name: Pistacia Facebook Tags
 * Plugin URI: http://wp.pistaciatheme.com/pistacia
 * Description: This plugin adds some Facebook Open Graph tags to our single posts.
 * Version: 1.6.7
 * Author: Pistaciatheme
 * Author URI: http://themeforest.net/user/pistaciatheme
 * License: GPL-3.0
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define('PISTACIA_FACEBOOK_TAGS_PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('PISTACIA_FACEBOOK_TAGS_PLUGIN_URI', plugin_dir_url( __FILE__ ));

/**
 * Class autoloader
 */
function pistacia_facebook_tags_autoloader( $className )  {
    $file = plugin_dir_path( __FILE__ ) . '/class/' . strtolower($className) . '.php';
    if( file_exists( $file ) ) {
        require_once( $file );
    }
}

spl_autoload_register('pistacia_facebook_tags_autoloader');

Pistacia_Facebook_Tags::get_instance();