<?php
/**
 * pistacia_gallery_manager.php
 *
 * This file Pistacia_Gallery_manager class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.2
 */

if ( !class_exists( 'Pistacia_Gallery_Manager' ) ) {
    class Pistacia_Gallery_Manager
    {
        private static $instance;

        protected function __construct()
        {

            add_action('after_setup_theme', array($this, 'pistacia_gallery_type'));

            add_action('plugins_loaded', array(&$this, 'load_textdomain'));

            add_action('init',array($this,'acf_pro_settings'));

        }

        /**
         * Settings Advanced Custom Fields
         */
        public function acf_pro_settings()
        {
            if ( function_exists( 'acf_add_local_field_group' ) ) {

                /**
                 * Gallery
                 */
                acf_add_local_field_group( array(
                    'key'                   => 'group_ps_glr_37653',
                    'title'                 => esc_html__( 'Gallery photos', 'pistacia' ),
                    'fields'                => array(
                        array(
                            'key'           => 'field_ps_glr_547645',
                            'label'         => esc_html__( 'Gallery items', 'pistacia' ),
                            'name'          => 'ps_gallery_items',
                            'return_format' => 'object',
                            'type'          => 'gallery',
                            'instructions'  => esc_html__( 'Gallery photos settings', 'pistacia' )
                        ),
                    ),
                    'location'              => array(
                        array(
                            array(
                                'param'    => 'post_type',
                                'operator' => '==',
                                'value'    => 'gallery',
                            )
                        ),
                    ),
                    'menu_order'            => 0,
                    'position'              => 'normal',
                    'style'                 => 'default',
                    'label_placement'       => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen'        => '',
                ) );

            }
        }

        /**
         * @return mixed
         */
        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        /**
         * Textdomain loading
         */
        public function load_textdomain()
        {
            load_theme_textdomain('pistacia_gallery_manager', PISTACIA_GALLERY_MANAGER_PLUGIN_DIR . '/lang');
        }

        /**
         * pistacia_menus_type
         *
         * Custom post type ( Menus )
         *
         * supports
         * title
         * editor (content)
         * author
         * thumbnail (featured image) (current theme must also support Post Thumbnails)
         * excerpt
         * trackbacks
         * custom-fields (see Custom_Fields, aka meta-data)
         * comments (also will see comment count balloon on edit screen)
         * revisions (will store revisions)
         * page-attributes (template and menu order) (hierarchical must be true)
         * post-formats (see Post_Formats)
         *
         * @param void
         * @return void
         *
         * */
        public function pistacia_gallery_type()
        {

            register_post_type('gallery',array(
                'labels' => array('name' => esc_html__('Gallery','pistacia_plugin')),
                'supports' => array('title','excerpt','editor','thumbnail'),
                'public' => true,
                'menu_icon' => 'dashicons-format-image',
                'menu_position' => 5
            ));

            register_taxonomy('gallery_category','gallery',array(
                'hierarchical' => true,
                'label' => esc_html__('Gallery categories','pistacia_plugin'),
                'query_var' => true
            ));

        }

    }

}