/** PISTACIA-RECIPE-MANAGER.JS
 =====================================================================================
 This file contains Pistacia Recipe Manager plugin scripts
 =====================================================================================
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 =====================================================================================*/

var Pistacia_Recipe = {
    submitRecipe : function( unique_id ){

        var args = '';

        var modal = jQuery('#submit-recipe-modal-' + unique_id);

        var modal_container = modal.find('.modal-body-inner');
        var modal_footer = modal.find('.modal-footer');
        var submit_btn = jQuery('#submit-recipe-button-' + unique_id);

        var form_data = new FormData();

        form_data.append('unique_id', unique_id );

        var serialized_data = jQuery('form').serializeArray();
        $.each(other_data,function(key,input){
            fd.append(input.name,input.value);
        });

        console.log( form_data );

        //submit_btn.button('loading');

        /*
        jQuery.ajax({
            type: "post",
            url: pistacia_recipe_manager_localize['ajax_url'],
            data: form_data, //'unique_id=' + unique_id + '&featured_img=' + jQuery('#sbmt-recipe-featured-img-' + unique_id ).val() + '&' + jQuery('form#submit-recipe-form-' + unique_id ).serialize() + '&action=pistacia_ajax_submit_recipe',
            processData: false,
            contentType: false,
            success: function (msg) {
                console.log(msg);
                submit_btn.button('reset');
            },
            error: function () {
            }
        }).then(function () {

        });
*/

    }
};

var Pistacia_Recipe_Validator = {
    validateRecipeArgs : function(){
        return true;
    }
};


/**
 * Submit recipe in frontend
 * User can send recipe
 */
(function(){

    jQuery(document).ready(function () {

        if( jQuery('.submit-recipe-section').length > 0 ){

            if (pistacia_recipe_manager_localize['pistacia_recipes_tags_json_exist']) {

                var date = new Date();
                var json_file_url = pistacia_recipe_manager_localize['get_template_directory_uri'] + '/jsons/pistacia_recipes_tags.json';

                var pistacia_recipe_tags = new Bloodhound({
                    datumTokenizer: Bloodhound.tokenizers.obj.whitespace('text'),
                    queryTokenizer: Bloodhound.tokenizers.whitespace,
                    prefetch: {
                        url: json_file_url + '?' + date.getFullYear().toString() + date.getSeconds().toString() + date.getMilliseconds().toString()
                    }
                });

                pistacia_recipe_tags.initialize();

                jQuery(document).on('click', '.submit-recipe-modal-show', function (e) {

                    var _this = jQuery(this);
                    var modal = jQuery(_this.data('modal-id'));
                    var unique_id = _this.data('unique-id');
                    var modal_container = modal.find('.modal-body-inner');
                    var button = jQuery(this);
                    var modal_footer = modal.find('.modal-footer');

                    modal.modal('show');

                    var elt = jQuery('#sbmt-recipe-tags-' + unique_id);

                    elt.tagsinput({
                        itemValue: 'value',
                        itemText: 'text',
                        typeaheadjs: {
                            name: 'pistacia_recipe_tags',
                            displayKey: 'text',
                            source: pistacia_recipe_tags.ttAdapter()
                        }
                    });

                    e.preventDefault();

                });

                jQuery(document).on('click', '.submit-recipe-button', function (e) {

                    if ( Pistacia_Recipe_Validator.validateRecipeArgs() ){

                        var unique_id = jQuery(this).data( 'unique-id' );
                        Pistacia_Recipe.submitRecipe( unique_id );

                    }

                    e.preventDefault();

                });

            }

        }


    });

})();



var Pistacia_Recipes = {
    elems : '',
    postType : 'pistacia-recipes',
    cousinesSelect : 'select#pistacia-recipe-cousines',
    categoriesSelect : 'select#pistacia-recipe-categories',
    tagsSelect : 'select#pistacia-recipe-tags',
    keywordsSelect : 'input#pistacia-recipe-keywords',
    recipesContainer : '#recipes-container',
    favouriteButton:'#recipe-favourites-btn',
    searchButton:'#pistacia-recipe-search-button',
    recipeBoxes:'#recipe-boxes',
    loader:'.item-loading',
    recipesFindCount : '.pistacia-recipe-bar #recipes-found',
    resetSearchBtn:'#pistacia-recipes-reset-search',
    recipesData:'.recipes-data',
    defaultPostPerPage : function(){
        return jQuery(Pistacia_Recipes.recipesContainer).data('default-postperpage');
    },
    defaultPaged : function(){
        return jQuery(Pistacia_Recipes.recipesContainer).data('default-paged');
    },
    resetFilters:function(){
        jQuery(Pistacia_Recipes.cousinesSelect).val('all');
        jQuery(Pistacia_Recipes.categoriesSelect).val('all');
        jQuery(Pistacia_Recipes.tagsSelect).val('all');
        jQuery(Pistacia_Recipes.keywordsSelect).val('');
    },
    saveFavourite:function( _this ){
        var postID = _this.data('recipe-post-id');
        if( Cookies.get( 'pistacia-recipes-favourites' ) == undefined ){
            Cookies.set( 'pistacia-recipes-favourites', postID, {
                expires: 365
            });
            _this.addClass('active');
            jQuery( Pistacia_Recipes.favouriteButton ).fadeIn('slow');
        } else {
            var pistacia_recipes = Cookies.get( 'pistacia-recipes-favourites' );
            var arr = pistacia_recipes.split(',');
            var id = ''+postID;
            if( arr.indexOf( id ) == '-1' ){
                pistacia_recipes += ',' + postID;
                Cookies.set( 'pistacia-recipes-favourites' , pistacia_recipes );
                _this.addClass('active');
            } else {
                _this.removeClass('active');
                if ( arr.length == 1 ){
                    Cookies.remove( 'pistacia-recipes-favourites' );
                    jQuery(Pistacia_Recipes.favouriteButton).fadeOut('slow');
                } else {
                    if ( arr.indexOf( id ) != 0 ){
                        pistacia_recipes = pistacia_recipes.replace( ',' + postID , '' );
                    } else {
                        pistacia_recipes = pistacia_recipes.replace( postID + ',' , '' );
                    }
                    Cookies.set('pistacia-recipes-favourites', pistacia_recipes);
                }
            }
        }
    },
    listRecipes : function( args ){
        jQuery.ajax({
            type: "post",
            url: pistacia_recipe_manager_localize['ajax_url'],
            data: 'args=' + args + '&action=pistacia_ajax_getrecipes',
            success: function ( items ) {
                Pistacia_Recipes.elems = jQuery( items );
            },
            error: function () {
            }
        }).then(function(){
            jQuery(Pistacia_Recipes.searchButton).button('reset');
            jQuery(Pistacia_Recipes.loader,Pistacia_Recipes.recipeBoxes).hide();
            jQuery(Pistacia_Recipes.recipesContainer).append( Pistacia_Recipes.elems );
            if ( Pistacia_Recipes.elems != '' ) {
                if( Cookies.get('pistacia_recipes_current_page') != undefined ){
                    var currentPaged = parseInt(Cookies.get('pistacia_recipes_current_page'));
                    Cookies.set('pistacia_recipes_current_page', currentPaged + 1);
                } else {
                    Cookies.set('pistacia_recipes_current_page', parseInt(Pistacia_Recipes.defaultPaged()));
                }
            }
            jQuery(Pistacia_Recipes.recipesFindCount).html(jQuery(Pistacia_Recipes.recipesData).data('found-posts'));
        });
    },
    getSearchQuery:function(){

        var cousines = jQuery(Pistacia_Recipes.cousinesSelect).val();
        var categories = jQuery(Pistacia_Recipes.categoriesSelect).val();
        var tags = jQuery(Pistacia_Recipes.tagsSelect).val();
        var keywords = jQuery(Pistacia_Recipes.keywordsSelect).val();

        var args = [];
        var tax_query = '';
        var search_query = '';

        if ( keywords != '' ){
            search_query = ',s=' + keywords;
        }

        if ( cousines != 'all' ){
            if( tax_query == '' ){ tax_query = ',tax_query='; }
            tax_query += 'pistacia-recipes-cousines;' + cousines + ';term_id;';
        }

        if ( categories != 'all' ){
            if( tax_query == '' ){ tax_query = ',tax_query='; }
            tax_query += 'pistacia-recipes-categories;' + categories + ';term_id;';
        }

        if ( tags != 'all' ){
            if( tax_query == '' ){ tax_query = ',tax_query='; }
            tax_query += 'pistacia-recipes-tags;' + tags + ';term_id;';
        }

        args['tax_query'] = tax_query;
        args['search_query'] = search_query;

        return args;

    },
    init:function(){
        var taxonomy = jQuery(Pistacia_Recipes.recipesContainer).data('taxonomy');
        var termid = jQuery(Pistacia_Recipes.recipesContainer).data('termid');

        var args = 'post_type=' + Pistacia_Recipes.postType + ',paged=' + Pistacia_Recipes.defaultPaged() + ',posts_per_page=' + Pistacia_Recipes.defaultPostPerPage();

        if ( taxonomy != '' && termid!='' ) {
            args += ',tax_query=' + taxonomy + ';' + termid + ';term_id';
            Cookies.set(',pistacia_recipes_tax_query', 'tax_query=' + taxonomy + ';' + termid + ';term_id' );
        } else {
            Cookies.set('pistacia_recipes_query', '' );
        }

        Cookies.set('pistacia_recipes_current_page', 0);
        Pistacia_Recipes.listRecipes( args );
    }
};


( function(){

    "use strict";

    if( document.getElementById('recipe-boxes') ){

        Pistacia_Recipes.init();

    }

    jQuery('.recipe-print-btn').on('click',function(e){
        window.print();
        e.preventDefault();
    });

    /**
     * Search bar
     *
     * search button action
     */
    if( document.getElementById('recipe-search-bar-section') ) {

        var searchButton = jQuery(Pistacia_Recipes.searchButton);

        searchButton.on('click',function(e){

            var args = 'post_type=' + Pistacia_Recipes.postType + ',paged=1,posts_per_page=' + Pistacia_Recipes.defaultPostPerPage();

            var container = jQuery(Pistacia_Recipes.recipesContainer);
            var query = Pistacia_Recipes.getSearchQuery();
            var resetSearchBtn = jQuery(Pistacia_Recipes.resetSearchBtn);

            container.html('');
            container.data('taxonomy','');
            container.data('termid','');

            searchButton.button('loading');
            jQuery(Pistacia_Recipes.loader,Pistacia_Recipes.recipeBoxes).show();

            if( query['tax_query'] !='' || query['search_query'] !='' ){
                resetSearchBtn.fadeIn('slow');
            } else {
                resetSearchBtn.fadeOut('slow');
            }

            Cookies.set('pistacia_recipes_current_page', 0);
            Cookies.set('pistacia_recipes_query',query['search_query'] + query['tax_query'].substring(0, query['tax_query'].length-1) );

            //console.log( args + query['search_query'] + query['tax_query'].substring(0, query['tax_query'].length-1) );

            Pistacia_Recipes.listRecipes( args + query['search_query'] + query['tax_query'].substring(0, query['tax_query'].length-1) );

            e.preventDefault();

        });

    }


    /**
     * Recipes paged button on the bottom actions
     */
    jQuery('#more-recipes-button').on('click',function(e){

        var currentPaged = parseInt(Cookies.get('pistacia_recipes_current_page'));
        var taxonomy = jQuery(Pistacia_Recipes.recipesContainer).data('taxonomy');
        var termid = jQuery(Pistacia_Recipes.recipesContainer).data('termid');
        var args = 'post_type=' + Pistacia_Recipes.postType + ',paged=' + (currentPaged+1) + ',posts_per_page=' + Pistacia_Recipes.defaultPostPerPage();

        jQuery(Pistacia_Recipes.loader,Pistacia_Recipes.recipeBoxes).show();

        if ( taxonomy != '' && termid!='' ) {
            args += ',tax_query=' + taxonomy + ';' + termid + ';term_id';
        } else {
            args += Cookies.get('pistacia_recipes_query');
        }

        Pistacia_Recipes.listRecipes( args );

        e.preventDefault();

    });


    /**
     * Recipe box add or remove favourite button action
     */
    jQuery('.recipe-boxes-section').on('click','a.recipe-add-to-favourite',function(e){

        var _this = jQuery(this);
        Pistacia_Recipes.saveFavourite(_this);
        e.preventDefault();

    });


    /**
     * Recipe favourite button list all favourites
     */
    jQuery('#recipe-favourites-btn').on('click',function(e){

        var args = 'post_type=' + Pistacia_Recipes.postType + ',paged=1,posts_per_page=' + Pistacia_Recipes.defaultPostPerPage();
        var container = jQuery(Pistacia_Recipes.recipesContainer);
        var pistacia_recipes = Cookies.get( 'pistacia-recipes-favourites' );
        var favourites = pistacia_recipes.split(',');
        var tax_query = '';

        if (favourites.length == 1){
            tax_query = ',post__in=' + favourites;
        } else {
            tax_query = ',post__in=' + favourites.join(';');
        }

        jQuery(Pistacia_Recipes.loader,Pistacia_Recipes.recipeBoxes).show();

        container.html('');
        container.data('taxonomy','');
        container.data('termid','');

        Cookies.set('pistacia_recipes_current_page', 0);
        Cookies.set('pistacia_recipes_query', tax_query);

        Pistacia_Recipes.listRecipes( args + tax_query );

        e.preventDefault();

    });



    jQuery('#pistacia-recipes-reset-search').on('click',function(e){

        var args = 'post_type=' + Pistacia_Recipes.postType + ',paged=1,posts_per_page=' + Pistacia_Recipes.defaultPostPerPage();
        var container = jQuery(Pistacia_Recipes.recipesContainer);

        jQuery(Pistacia_Recipes.loader,Pistacia_Recipes.recipeBoxes).show();

        container.html('');
        container.data('taxonomy','');
        container.data('termid','');

        Cookies.set('pistacia_recipes_current_page', 0);
        Cookies.set('pistacia_recipes_query', '');

        Pistacia_Recipes.listRecipes( args );

        Pistacia_Recipes.resetFilters();

        jQuery(this).fadeOut('slow');

        e.preventDefault();

    });

})();