<?php
/**
 * pistacia_menu_manager.php
 *
 * This file Pistacia_Menu_manager class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.4.0
 */

if ( !class_exists( 'Pistacia_Menu_Manager' ) ) {
    class Pistacia_Menu_Manager
    {
        private static $instance;

        protected function __construct()
        {

            add_action('after_setup_theme', array($this, 'pistacia_menus_type'));

            add_action('plugins_loaded', array(&$this, 'load_textdomain'));

            if (!is_admin()) {
                add_action('wp_enqueue_scripts', array($this, 'menus_enqueue_scripts_styles'));
            }

            add_action('init',array($this,'acf_pro_settings'));

        }

        public function the_menus_accordion($args)
        {?>

            <?php $categories = get_terms( 'pistacia-menus-categories', array(
            'include' => $args['categories'],
            'orderby' => 'title' ) ); ?>

            <?php foreach ( $categories as $cat ) : ?>

            <div class="food-menus-items food-menus-accordion">

                <h3 class="title">
                    <a href="#">
                        <i class="fa fa-plus-square"></i>
                        <span<?php echo ($args['text_color'] != '') ? ' style="color:' . $args['text_color'] . '"' : '';?>><?php echo esc_html($cat->name); ?></span>
                        <span class="line"<?php echo ($args['text_color'] != '') ? ' style="background-color:' . $args['text_color'] . '"' : '';?>></span>
                        <?php if ($args['show_count']) : ?>
                            <span class="count"<?php echo ($args['text_color'] != '') ? ' style="color:' . $args['text_color'] . '"' : '';?>>(<?php echo esc_html($cat->count); ?>)</span>
                        <?php endif; ?>
                    </a>
                </h3>

                <?php $the_query = new WP_Query( array(
                    'post_type' => 'pistacia-menus',
                    'paged' => 1,
                    'posts_per_page' => -1,
                    'status' => 'published',
                    'orderby' => $args['item_order_by'],
                    'order'   => $args['item_order'],
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'pistacia-menus-categories',
                            'field'    => 'term_id',
                            'terms'    => $cat->term_id,
                        ),
                    )
                ) ); ?>

                <ul class="items">

                    <?php while ( $the_query->have_posts() ) : ?>

                        <?php $the_query->the_post(); ?>

                        <?php $li_class = 'item'; ?>
                        <?php $thumb_src = wp_get_attachment_image_src(get_post_thumbnail_id( get_the_ID() ), 'thumbnail');?>
                        <?php $large_src = wp_get_attachment_image_src(get_post_thumbnail_id( get_the_ID() ), 'full');?>
                        <?php $menus_featured = get_the_terms(get_the_ID(), 'pistacia-menus-featured'); ?>

                        <?php if ( !empty($menus_featured) ){
                            $li_class .= ' active';
                        } ?>

                        <?php if (!empty($thumb_src) && !empty($args['show_photo']) ){
                            $li_class .= ' item-with-photo';
                        } ?>

                        <li class="<?php echo esc_attr($li_class); ?>">

                            <?php if( !empty( $args['show_photo'] ) ) : ?>

                                <?php if (!empty($thumb_src)) : ?>
                                    <div class="photo">
                                        <a href="<?php echo esc_url($large_src[0]);?>" class="swipebox" rel="gallery-menus-<?php esc_attr($cat->name); ?>" title="">
                                            <img src="<?php echo esc_url($thumb_src[0]);?>" class="img-responsive <?php echo $args['photo_style']; ?>">
                                        </a>
                                    </div>
                                <?php endif; ?>

                            <?php endif; ?>

                            <div class="text-wrapper">

                                <h3>
                                    <span class="name"<?php echo ($args['text_color'] != '') ? ' style="color:' . $args['text_color'] . '"' : '';?>><?php echo esc_html( get_the_title() ); ?></span>

                                    <?php if( function_exists( 'get_field' ) ) {
                                        if( get_field('pistacia_menu_price') ) { ?>
                                            <span class="price"<?php echo ($args['text_color'] != '') ? ' style="background-color:' . $args['text_color'] . '"' : '';?>><?php echo esc_html(get_field('pistacia_menu_price')); ?></span>
                                        <?php }
                                    } ?>
                                </h3>

                                <?php $tags = get_the_terms(get_the_ID(), 'pistacia-menus-tags'); ?>

                                <div class="clearfix">

                                    <?php if (!empty($tags)) : ?>
                                        <ul class="meta pull-left">
                                            <?php foreach( $tags as $tag ) : ?>
                                                <li<?php echo ($args['text_color'] != '') ? ' style="color:' . $args['text_color'] . '"' : '';?>><?php print($tag->name);?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>

                                    <?php if (!empty($menus_featured)) : ?>
                                        <ul class="featured pull-right">
                                            <?php foreach( $menus_featured as $featured ) : ?>
                                                <li<?php echo ($args['text_color'] != '') ? ' style="color:' . $args['text_color'] . '"' : '';?>><?php print($featured->name);?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>

                                </div>

                            </div>

                        </li>

                    <?php endwhile; ?>

                </ul>

            </div>

        <?php endforeach; ?>

            <?php wp_reset_postdata(); ?>

        <?php }

        /**
         * Settings Advanced Custom Fields
         */
        public function acf_pro_settings()
        {
            if ( function_exists( 'acf_add_local_field_group' ) ) {

                register_field_group( array(
                    'key'                   => 'group_ps_pstcmnmng',
                    'title'                 => esc_html__( 'Menu properties', 'pistacia_menu_manager' ),
                    'fields'                => array(
                        array(
                            'key'      => 'field_ps_pstcmnmng1',
                            'label'    => esc_html__( 'Price', 'pistacia_menu_manager' ),
                            'name'     => 'pistacia_menu_price',
                            'type'         => 'text',
                            'required'     => 1,
                            'instructions' => esc_html__('Menu price','pistacia_menu_manager'),
                        ),
                    ),
                    'location'              => array(
                        array(
                            array(
                                'param'    => 'post_type',
                                'operator' => '==',
                                'value'    => 'pistacia-menus',
                            ),
                        ),
                    ),
                    'menu_order'            => 0,
                    'position'              => 'normal',
                    'style'                 => 'default',
                    'label_placement'       => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen'        => array(

                    ),
                ) );

            }
        }

        public function menus_enqueue_scripts_styles()
        {

            wp_enqueue_style(
                'pistacia-menu-manager',
                esc_url( PISTACIA_MENU_MANAGER_PLUGIN_URI ) . 'assets/css/pistacia-menu-manager.min.css',
                array(),
                '1.6.7',
                'all'
            );

            wp_enqueue_script(
                'pistacia-menu-manager-js',
                PISTACIA_MENU_MANAGER_PLUGIN_URI . 'assets/js/pistacia-menu-manager.min.js',
                array('jquery','pistacia-vendors-js'),
                '1.6.7',
                true
            );

        }

        /**
         * Only Visual Composer select element
         *
         * @return array
         */
        public function get_menus_categories_select()
        {

            $cats = get_terms( array(
                'taxonomy' => 'pistacia-menus-categories',
                'hide_empty' => false,
            ) );

            $ret = array();

            foreach($cats as $cat){
                $ret[$cat->name] = $cat->term_id;
            }

            return $ret;

        }

        /**
         * @return mixed
         */
        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        /**
         * Textdomain loading
         */
        public function load_textdomain()
        {
            load_theme_textdomain('pistacia_menu_manager', PISTACIA_MENU_MANAGER_PLUGIN_DIR . '/lang');
        }

        /**
         * pistacia_menus_type
         *
         * Custom post type ( Menus )
         *
         * supports
         * title
         * editor (content)
         * author
         * thumbnail (featured image) (current theme must also support Post Thumbnails)
         * excerpt
         * trackbacks
         * custom-fields (see Custom_Fields, aka meta-data)
         * comments (also will see comment count balloon on edit screen)
         * revisions (will store revisions)
         * page-attributes (template and menu order) (hierarchical must be true)
         * post-formats (see Post_Formats)
         *
         * @param void
         * @return void
         *
         * */
        public function pistacia_menus_type()
        {

            register_post_type('pistacia-menus', array(
                'labels' => array('name' => esc_html__('Menus', 'pistacia_menu_manager')),
                'supports' => array('title','excerpt', 'revisions', 'thumbnail'),
                'public' => true,
                'menu_icon' => 'dashicons-edit',
                'menu_position' => 6,
                'show_in_nav_menus' => false
            ));

            register_taxonomy('pistacia-menus-categories', 'pistacia-menus', array(
                'hierarchical' => true,
                'label' => esc_html__('Menus categories', 'pistacia_menu_manager'),
                'query_var' => true,
                'show_in_nav_menus' => false
            ));

            register_taxonomy('pistacia-menus-featured', 'pistacia-menus', array(
                'hierarchical' => true,
                'label' => esc_html__('Menus featured', 'pistacia_menu_manager'),
                'query_var' => true,
                'show_in_nav_menus' => false
            ));

            register_taxonomy('pistacia-menus-tags', 'pistacia-menus', array(
                'hierarchical' => false,
                'label' => esc_html__('Menus tags', 'pistacia_menu_manager'),
                'query_var' => true,
                'show_in_nav_menus' => false
            ));


        }

    }

}