<?php
/**
 * pistacia_facebook_tags.php
 *
 * This file Pistacia_Facebook_Tags class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.4
 */

if ( !class_exists( 'Pistacia_Facebook_Tags' ) ) {
    class Pistacia_Facebook_Tags
    {
        private static $instance;

        protected function __construct()
        {
            add_action('plugins_loaded', array(&$this, 'load_textdomain'));
            add_action( 'wp_head', array($this,'add_facebook_tags') );
        }

        /**
         * @return mixed
         */
        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        public function add_facebook_tags()
        {?>

            <?php $attach_img = ( has_post_thumbnail() ) ? wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' ) : '';
            $image = '';
            if( empty( $attach_img )){
                if ( function_exists('get_field') && get_field('pistacia_facebook_splash_image','option')){
                    $image = get_field('pistacia_facebook_splash_image','option');
                }
            } else {
                $image = $attach_img[0];
            } ?>

            <?php if( is_single() || is_page() && !is_front_page() ) : ?>
                <meta property="og:title" content="<?php the_title(); ?>" />
                <meta property="og:site_name" content="<?php bloginfo( 'name' ); ?>" />
                <meta property="og:url" content="<?php the_permalink(); ?>" />
                <meta property="og:description" content="<?php echo esc_html(get_the_excerpt()); ?>" />
                <meta property="og:type" content="article" />

                <?php if ( !empty( $image ) ) : ?>
                    <meta property="og:image" content="<?php echo esc_url($image); ?>"/>
                <?php endif; ?>

            <?php endif ?>

            <?php if( is_home() || is_front_page() ) : ?>
                <meta property="og:title" content="<?php bloginfo('name'); ?>" />
                <meta property="og:site_name" content="<?php bloginfo( 'name' ); ?>" />
                <meta property="og:url" content="<?php echo esc_url(get_home_url()); ?>" />
                <meta property="og:description" content="<?php bloginfo( 'description' ); ?>" />
                <meta property="og:type" content="blog" />

                <?php if ( !empty( $image ) ) : ?>
                    <meta property="og:image" content="<?php echo esc_url($image); ?>"/>
                <?php endif; ?>
            
            <?php endif ?>

        <?php }

        /**
         * Textdomain loading
         */
        public function load_textdomain()
        {
            load_theme_textdomain('pistacia_facebook_tags', PISTACIA_FACEBOOK_TAGS_PLUGIN_DIR . '/lang');
        }

    }

}